/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.auth.UserAuthority;
import org.molgenis.data.security.auth.UserAuthorityFactory;
import org.molgenis.data.security.permission.PermissionSystemService;
import org.molgenis.data.security.user.UserService;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.security.permission.AuthenticationAuthoritiesUpdater;
import org.molgenis.security.permission.PrincipalSecurityContextRegistry;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class PermissionSystemServiceImpl
implements PermissionSystemService {
    private final UserService userService;
    private final UserAuthorityFactory userAuthorityFactory;
    private final RoleHierarchy roleHierarchy;
    private final DataService dataService;
    private final PrincipalSecurityContextRegistry principalSecurityContextRegistry;
    private final AuthenticationAuthoritiesUpdater authenticationAuthoritiesUpdater;

    public PermissionSystemServiceImpl(UserService userService, UserAuthorityFactory userAuthorityFactory, RoleHierarchy roleHierarchy, DataService dataService, PrincipalSecurityContextRegistry principalSecurityContextRegistry, AuthenticationAuthoritiesUpdater authenticationAuthoritiesUpdater) {
        this.userService = Objects.requireNonNull(userService);
        this.userAuthorityFactory = Objects.requireNonNull(userAuthorityFactory);
        this.roleHierarchy = Objects.requireNonNull(roleHierarchy);
        this.dataService = Objects.requireNonNull(dataService);
        this.principalSecurityContextRegistry = Objects.requireNonNull(principalSecurityContextRegistry);
        this.authenticationAuthoritiesUpdater = Objects.requireNonNull(authenticationAuthoritiesUpdater);
    }

    public void giveUserWriteMetaPermissions(EntityType entityType) {
        this.giveUserWriteMetaPermissions(Collections.singleton(entityType));
    }

    public void giveUserWriteMetaPermissions(Collection<EntityType> entityTypes) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return;
        }
        Collection<GrantedAuthority> grantedAuthorities = this.getGrantedAuthorities(entityTypes);
        this.giveUserEntityPermissionsAsSystem(grantedAuthorities);
    }

    private void giveUserEntityPermissionsAsSystem(Collection<GrantedAuthority> authorities) {
        String currentUsername = SecurityUtils.getCurrentUsername();
        RunAsSystemAspect.runAsSystem(() -> this.updatePersistedUserAuthorities(currentUsername, authorities));
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Stream<SecurityContext> securityContexts = this.principalSecurityContextRegistry.getSecurityContexts(principal);
        Collection reachableAuthorities = this.roleHierarchy.getReachableGrantedAuthorities(authorities);
        securityContexts.forEach(securityContext -> this.updateSecurityContextAuthorities((SecurityContext)securityContext, reachableAuthorities));
    }

    private void updateSecurityContextAuthorities(SecurityContext securityContext, Collection<? extends GrantedAuthority> newAuthorities) {
        Collection authorities = securityContext.getAuthentication().getAuthorities();
        ArrayList<GrantedAuthority> updatedAuthorities = new ArrayList<GrantedAuthority>(authorities);
        updatedAuthorities.addAll(newAuthorities);
        Authentication updatedAuthentication = this.authenticationAuthoritiesUpdater.updateAuthentication(securityContext.getAuthentication(), updatedAuthorities);
        securityContext.setAuthentication(updatedAuthentication);
    }

    private Collection<GrantedAuthority> getGrantedAuthorities(Collection<EntityType> entityTypeStream) {
        return entityTypeStream.stream().map(this::toGrantedAuthority).collect(Collectors.toList());
    }

    private GrantedAuthority toGrantedAuthority(EntityType entityType) {
        String role = "ROLE_ENTITY_" + Permission.WRITEMETA.toString() + '_' + entityType.getId();
        return new SimpleGrantedAuthority(role);
    }

    private void updatePersistedUserAuthorities(String currentUsername, Collection<GrantedAuthority> grantedAuthorities) {
        User user = this.userService.getUser(currentUsername);
        Stream<UserAuthority> userAuthorityStream = grantedAuthorities.stream().map(grantedAuthority -> {
            UserAuthority userAuthority = (UserAuthority)this.userAuthorityFactory.create();
            userAuthority.setUser(user);
            userAuthority.setRole(grantedAuthority.getAuthority());
            return userAuthority;
        });
        this.dataService.add("sys_sec_UserAuthority", userAuthorityStream);
    }
}

