/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.twofactor.auth;

import java.util.Objects;
import org.molgenis.security.twofactor.auth.RecoveryAuthenticationProvider;
import org.molgenis.security.twofactor.auth.RecoveryAuthenticationToken;
import org.molgenis.security.twofactor.service.RecoveryService;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class RecoveryAuthenticationProviderImpl
implements RecoveryAuthenticationProvider {
    private final RecoveryService recoveryService;

    public RecoveryAuthenticationProviderImpl(RecoveryService recoveryService) {
        this.recoveryService = Objects.requireNonNull(recoveryService);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            throw new IllegalArgumentException("Only RecoveryAuthenticationToken is supported");
        }
        RecoveryAuthenticationToken authToken = (RecoveryAuthenticationToken)authentication;
        if (authToken.getRecoveryCode() == null) {
            throw new BadCredentialsException("Invalid recovery code or code already used");
        }
        this.recoveryService.useRecoveryCode(authToken.getRecoveryCode());
        UserDetails userDetails = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        authToken = new RecoveryAuthenticationToken(userDetails, userDetails.getPassword(), userDetails.getAuthorities(), authToken.getRecoveryCode());
        return authToken;
    }

    public boolean supports(Class<?> authentication) {
        return RecoveryAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

