/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.twofactor.model;

import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.auth.SecurityPackage;
import org.springframework.stereotype.Component;

@Component
public class UserSecretMetaData
extends SystemEntityType {
    public static final String ID = "id";
    public static final String USER_ID = "userId";
    public static final String SECRET = "secret";
    public static final String LAST_FAILED_AUTHENICATION = "last_failed_authentication";
    public static final String FAILED_LOGIN_ATTEMPTS = "failed_login_attempts";
    private static final String SIMPLE_NAME = "UserSecret";
    public static final String USER_SECRET = "sys_sec_UserSecret";
    private final SecurityPackage securityPackage;

    public UserSecretMetaData(SecurityPackage securityPackage) {
        super(SIMPLE_NAME, "sys_sec");
        this.securityPackage = Objects.requireNonNull(securityPackage);
    }

    public void init() {
        this.setLabel("User Secret");
        this.setPackage((Package)this.securityPackage);
        this.setDescription("Secret that is used to authenticate user with 2 factor authentication");
        this.addAttribute(ID, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setAuto(true).setVisible(false).setLabel("Identifer");
        this.addAttribute(USER_ID, new EntityType.AttributeRole[0]).setNillable(false).setUnique(true).setLabel("User identifier");
        this.addAttribute(SECRET, new EntityType.AttributeRole[0]).setNillable(false).setLabel("Secret");
        this.addAttribute(LAST_FAILED_AUTHENICATION, new EntityType.AttributeRole[0]).setDataType(AttributeType.DATE_TIME).setNillable(true).setLabel("Is last successful authenticated at");
        this.addAttribute(FAILED_LOGIN_ATTEMPTS, new EntityType.AttributeRole[0]).setDefaultValue("0").setNillable(false).setDataType(AttributeType.INT).setLabel("Failed login attempts");
    }
}

