/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.user;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.data.DataService;
import org.molgenis.data.security.auth.GroupAuthority;
import org.molgenis.data.security.auth.GroupMember;
import org.molgenis.data.security.auth.UserAuthority;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.runas.RunAsSystem;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserDetailsService
implements org.springframework.security.core.userdetails.UserDetailsService {
    private final DataService dataService;
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;

    public UserDetailsService(DataService dataService, GrantedAuthoritiesMapper grantedAuthoritiesMapper) {
        this.dataService = Objects.requireNonNull(dataService, "DataService is null");
        this.grantedAuthoritiesMapper = Objects.requireNonNull(grantedAuthoritiesMapper, "Granted authorities mapper is null");
    }

    @RunAsSystem
    public UserDetails loadUserByUsername(String username) {
        try {
            org.molgenis.data.security.auth.User user = (org.molgenis.data.security.auth.User)this.dataService.findOne("sys_sec_User", new QueryImpl().eq("username", (Object)username), org.molgenis.data.security.auth.User.class);
            if (user == null) {
                throw new UsernameNotFoundException("unknown user '" + username + "'");
            }
            Collection<? extends GrantedAuthority> authorities = this.getAuthorities(user);
            return new User(user.getUsername(), user.getPassword(), user.isActive().booleanValue(), true, true, true, authorities);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<? extends GrantedAuthority> getAuthorities(org.molgenis.data.security.auth.User user) {
        List<UserAuthority> authorities = this.getUserAuthorities(user);
        List grantedAuthorities = authorities != null ? Lists.transform(authorities, authority -> new SimpleGrantedAuthority(authority.getRole())) : null;
        List<GroupAuthority> groupAuthorities = this.getGroupAuthorities(user);
        List grantedGroupAuthorities = groupAuthorities != null ? Lists.transform(groupAuthorities, groupAuthority -> new SimpleGrantedAuthority(groupAuthority.getRole())) : null;
        HashSet<SimpleGrantedAuthority> allGrantedAuthorities = new HashSet<SimpleGrantedAuthority>();
        if (grantedAuthorities != null) {
            allGrantedAuthorities.addAll(grantedAuthorities);
        }
        if (grantedGroupAuthorities != null) {
            allGrantedAuthorities.addAll(grantedGroupAuthorities);
        }
        if (user.isSuperuser() != null && user.isSuperuser().booleanValue()) {
            allGrantedAuthorities.add(new SimpleGrantedAuthority("ROLE_SU"));
        }
        return this.grantedAuthoritiesMapper.mapAuthorities(allGrantedAuthorities);
    }

    private List<UserAuthority> getUserAuthorities(org.molgenis.data.security.auth.User user) {
        return this.dataService.findAll("sys_sec_UserAuthority", new QueryImpl().eq("User", (Object)user), UserAuthority.class).collect(Collectors.toList());
    }

    private List<GroupAuthority> getGroupAuthorities(org.molgenis.data.security.auth.User user) {
        List groupMembers = this.dataService.findAll("sys_sec_GroupMember", new QueryImpl().eq("User", (Object)user), GroupMember.class).collect(Collectors.toList());
        if (!groupMembers.isEmpty()) {
            List groups = Lists.transform(groupMembers, GroupMember::getGroup);
            return this.dataService.findAll("sys_sec_GroupAuthority", new QueryImpl().in("Group", (Iterable)groups), GroupAuthority.class).collect(Collectors.toList());
        }
        return null;
    }
}

