/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import java.util.Objects;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/permission"})
public class MolgenisPermissionController {
    private final PermissionService permissionService;

    public MolgenisPermissionController(PermissionService permissionService) {
        this.permissionService = Objects.requireNonNull(permissionService);
    }

    @GetMapping(value={"/{entityTypeId}/read"})
    @ResponseBody
    public boolean hasReadPermission(@PathVariable(value="entityTypeId") String entityTypeId) {
        return this.permissionService.hasPermissionOnEntityType(entityTypeId, Permission.READ);
    }

    @GetMapping(value={"/{entityTypeId}/write"})
    @ResponseBody
    public boolean hasWritePermission(@PathVariable(value="entityTypeId") String entityTypeId) {
        return this.permissionService.hasPermissionOnEntityType(entityTypeId, Permission.WRITE);
    }
}

