/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.twofactor.service;

import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.user.UserService;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.security.twofactor.exceptions.InvalidVerificationCodeException;
import org.molgenis.security.twofactor.exceptions.TooManyLoginAttemptsException;
import org.molgenis.security.twofactor.model.UserSecret;
import org.molgenis.security.twofactor.model.UserSecretFactory;
import org.molgenis.security.twofactor.service.OtpService;
import org.molgenis.security.twofactor.service.TwoFactorAuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TwoFactorAuthenticationServiceImpl
implements TwoFactorAuthenticationService {
    private static final Logger LOG = LoggerFactory.getLogger(TwoFactorAuthenticationService.class);
    private static final int MAX_FAILED_LOGIN_ATTEMPTS = 3;
    private static final int FAILED_LOGIN_ATTEMPT_ITERATION = 1;
    private static final int BLOCKED_USER_INTERVAL = 30;
    private final OtpService otpService;
    private final DataService dataService;
    private final UserService userService;
    private final IdGenerator idGenerator;
    private final UserSecretFactory userSecretFactory;

    public TwoFactorAuthenticationServiceImpl(OtpService otpService, DataService dataService, UserService userService, IdGenerator idGenerator, UserSecretFactory userSecretFactory) {
        this.otpService = Objects.requireNonNull(otpService);
        this.dataService = Objects.requireNonNull(dataService);
        this.userService = Objects.requireNonNull(userService);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.userSecretFactory = Objects.requireNonNull(userSecretFactory);
    }

    @Override
    public boolean isVerificationCodeValidForUser(String verificationCode) {
        boolean isValid;
        block4: {
            isValid = false;
            UserSecret userSecret = this.getSecret();
            if (!this.userIsBlocked()) {
                try {
                    if (this.otpService.tryVerificationCode(verificationCode, userSecret.getSecret())) {
                        isValid = true;
                        this.updateFailedLoginAttempts(0);
                    }
                }
                catch (InvalidVerificationCodeException err) {
                    this.updateFailedLoginAttempts(userSecret.getFailedLoginAttempts() + 1);
                    if (this.userIsBlocked()) break block4;
                    throw err;
                }
            }
        }
        return isValid;
    }

    @Override
    public boolean userIsBlocked() {
        UserSecret userSecret = this.getSecret();
        if (userSecret.getFailedLoginAttempts() >= 3 && userSecret.getLastFailedAuthentication() != null && Instant.now().toEpochMilli() < userSecret.getLastFailedAuthentication().plus(Duration.ofSeconds(30L)).toEpochMilli()) {
            throw new TooManyLoginAttemptsException(MessageFormat.format("You entered the wrong verification code {0} times, please wait for {1} seconds before you try again", 3, 30));
        }
        return false;
    }

    @Override
    public void saveSecretForUser(String secret) {
        if (secret == null) {
            throw new InternalAuthenticationServiceException("No secretKey found");
        }
        User user = this.getUser();
        UserSecret userSecret = (UserSecret)this.userSecretFactory.create();
        userSecret.setUserId(user.getId());
        userSecret.setSecret(secret);
        RunAsSystemAspect.runAsSystem(() -> this.dataService.add("sys_sec_UserSecret", (Entity)userSecret));
    }

    @Override
    public void resetSecretForUser() {
        User user = this.getUser();
        Stream userSecrets = (Stream)RunAsSystemAspect.runAsSystem(() -> this.dataService.query("sys_sec_UserSecret", UserSecret.class).eq("userId", (Object)user.getId()).findAll());
        RunAsSystemAspect.runAsSystem(() -> this.dataService.delete("sys_sec_UserSecret", userSecrets));
    }

    @Override
    public void enableForUser() {
        User user = this.getUser();
        user.setTwoFactorAuthentication(true);
        this.userService.update(user);
    }

    @Override
    public void disableForUser() {
        User user = this.getUser();
        user.setTwoFactorAuthentication(false);
        this.userService.update(user);
        UserSecret userSecret = this.getSecret();
        RunAsSystemAspect.runAsSystem(() -> this.dataService.delete("sys_sec_UserSecret", (Entity)userSecret));
    }

    @Override
    public String generateSecretKey() {
        return this.idGenerator.generateId(IdGenerator.Strategy.SECURE_RANDOM);
    }

    @Override
    public boolean isConfiguredForUser() {
        boolean isConfigured = false;
        try {
            UserSecret secret = this.getSecret();
            if (StringUtils.hasText((String)secret.getSecret())) {
                isConfigured = true;
            }
        }
        catch (InternalAuthenticationServiceException err) {
            LOG.warn(err.getMessage());
        }
        return isConfigured;
    }

    private void updateFailedLoginAttempts(int numberOfAttempts) {
        UserSecret userSecret = this.getSecret();
        userSecret.setFailedLoginAttempts(numberOfAttempts);
        if (userSecret.getFailedLoginAttempts() >= 3) {
            if (userSecret.getLastFailedAuthentication() == null || Instant.now().toEpochMilli() >= userSecret.getLastFailedAuthentication().plus(Duration.ofSeconds(30L)).toEpochMilli()) {
                userSecret.setFailedLoginAttempts(1);
            }
        } else {
            userSecret.setLastFailedAuthentication(Instant.now());
        }
        RunAsSystemAspect.runAsSystem(() -> this.dataService.update("sys_sec_UserSecret", (Entity)userSecret));
    }

    private UserSecret getSecret() {
        User user = this.getUser();
        UserSecret secret = (UserSecret)((Object)RunAsSystemAspect.runAsSystem(() -> (UserSecret)this.dataService.query("sys_sec_UserSecret", UserSecret.class).eq("userId", (Object)user.getId()).findOne()));
        if (secret != null) {
            return secret;
        }
        throw new InternalAuthenticationServiceException(MessageFormat.format("Secret not found, user: [{0}] is not configured for two factor authentication", user.getUsername()));
    }

    private User getUser() {
        User user = this.userService.getUser(SecurityUtils.getCurrentUsername());
        if (user != null) {
            return user;
        }
        throw new UsernameNotFoundException(MessageFormat.format("Can not find user: [{0}]", SecurityUtils.getCurrentUsername()));
    }
}

