/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.acl;

import java.util.List;
import java.util.Objects;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;

public class BitMaskPermissionGrantingStrategy
implements PermissionGrantingStrategy {
    private final AuditLogger auditLogger;

    public BitMaskPermissionGrantingStrategy(AuditLogger auditLogger) {
        this.auditLogger = Objects.requireNonNull(auditLogger);
    }

    public boolean isGranted(Acl acl, List<Permission> permission, List<Sid> sids, boolean administrativeMode) {
        List aces = acl.getEntries();
        AccessControlEntry firstRejection = null;
        block0: for (Permission p : permission) {
            for (Sid sid : sids) {
                boolean scanNextSid = true;
                for (AccessControlEntry ace : aces) {
                    if (!BitMaskPermissionGrantingStrategy.containsPermission(ace.getPermission().getMask(), p.getMask()) || !ace.getSid().equals((Object)sid)) continue;
                    if (ace.isGranting()) {
                        if (!administrativeMode) {
                            this.auditLogger.logIfNeeded(true, ace);
                        }
                        return true;
                    }
                    if (firstRejection == null) {
                        firstRejection = ace;
                    }
                    scanNextSid = false;
                    break;
                }
                if (scanNextSid) continue;
                continue block0;
            }
        }
        if (firstRejection != null) {
            if (!administrativeMode) {
                this.auditLogger.logIfNeeded(false, firstRejection);
            }
            return false;
        }
        if (acl.isEntriesInheriting() && acl.getParentAcl() != null) {
            return acl.getParentAcl().isGranted(permission, sids, false);
        }
        throw new NotFoundException("Unable to locate a matching ACE for passed permissions and SIDs");
    }

    static boolean containsPermission(int mask, int permission) {
        return (mask & permission) != 0;
    }
}

