/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.token;

import java.util.Objects;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.core.token.TokenService;
import org.molgenis.security.token.RestAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;

public class TokenAuthenticationProvider
implements AuthenticationProvider {
    private final TokenService tokenService;
    private UserDetailsChecker userDetailsChecker;

    public TokenAuthenticationProvider(TokenService tokenService, UserDetailsChecker userDetailsChecker) {
        this.tokenService = Objects.requireNonNull(tokenService);
        this.userDetailsChecker = Objects.requireNonNull(userDetailsChecker);
    }

    @RunAsSystem
    public Authentication authenticate(Authentication authentication) {
        if (!this.supports(authentication.getClass())) {
            throw new IllegalArgumentException("Only RestAuthenticationToken is supported");
        }
        RestAuthenticationToken authToken = (RestAuthenticationToken)authentication;
        if (authToken.getToken() != null) {
            UserDetails userDetails = this.tokenService.findUserByToken(authToken.getToken());
            this.userDetailsChecker.check(userDetails);
            authToken = new RestAuthenticationToken(userDetails, userDetails.getPassword(), userDetails.getAuthorities(), authToken.getToken());
        }
        return authToken;
    }

    public boolean supports(Class<?> authentication) {
        return RestAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

