/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.token;

import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.security.token.TokenParam;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class TokenExtractor
implements HandlerMethodArgumentResolver {
    public static final String TOKEN_HEADER = "x-molgenis-token";
    public static final String TOKEN_PARAMETER = "molgenis-token";

    public static String getToken(HttpServletRequest request) {
        return TokenExtractor.getTokenInternal(request.getHeader(TOKEN_HEADER), request.getParameter(TOKEN_PARAMETER));
    }

    @Nullable
    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        return TokenExtractor.getTokenInternal(webRequest.getHeader(TOKEN_HEADER), webRequest.getParameter(TOKEN_PARAMETER), ((TokenParam)parameter.getParameterAnnotation(TokenParam.class)).required());
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(TokenParam.class);
    }

    private static String getTokenInternal(String tokenHeader, String tokenParam, boolean required) throws ServletRequestBindingException {
        Optional<String> token = Optional.ofNullable(TokenExtractor.getTokenInternal(tokenHeader, tokenParam));
        if (!token.isPresent() && required) {
            throw new ServletRequestBindingException("Missing molgenis token. Token should either be present in the x-molgenis-token request header or the molgenis-token parameter.");
        }
        return token.orElse(null);
    }

    private static String getTokenInternal(String tokenHeader, String tokenParam) {
        return Stream.of(tokenHeader, tokenParam).filter(StringUtils::isNotBlank).findFirst().orElse(null);
    }
}

