/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.user.UserService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.web.filter.GenericFilterBean;

public class MolgenisChangePasswordFilter
extends GenericFilterBean {
    private final UserService userService;
    private final RedirectStrategy redirectStrategy;

    public MolgenisChangePasswordFilter(UserService userService, RedirectStrategy redirectStrategy) {
        this.userService = userService;
        this.redirectStrategy = redirectStrategy;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && !authentication.getName().equals("anonymous") && !httpRequest.getRequestURI().equalsIgnoreCase("/account/password/change")) {
            User user = this.userService.getUser(authentication.getName());
            if (user == null) {
                throw new RuntimeException("Unknown username [" + authentication.getName() + "]");
            }
            if (user.isChangePassword() != null && user.isChangePassword().booleanValue()) {
                this.redirectStrategy.sendRedirect(httpRequest, httpResponse, "/account/password/change");
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

