/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.account;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.user.UserService;
import org.molgenis.security.account.AccountService;
import org.molgenis.security.account.EmailAlreadyExistsException;
import org.molgenis.security.account.UsernameAlreadyExistsException;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.settings.AuthenticationSettings;
import org.molgenis.security.user.MolgenisUserException;
import org.molgenis.settings.AppSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountServiceImpl
implements AccountService {
    private static final Logger LOG = LoggerFactory.getLogger(AccountServiceImpl.class);
    private final DataService dataService;
    private final MailSender mailSender;
    private final UserService userService;
    private final AppSettings appSettings;
    private final AuthenticationSettings authenticationSettings;
    private final IdGenerator idGenerator;

    AccountServiceImpl(DataService dataService, MailSender mailSender, UserService userService, AppSettings appSettings, AuthenticationSettings authenticationSettings, IdGenerator idGenerator) {
        this.dataService = Objects.requireNonNull(dataService);
        this.mailSender = Objects.requireNonNull(mailSender);
        this.userService = Objects.requireNonNull(userService);
        this.appSettings = Objects.requireNonNull(appSettings);
        this.authenticationSettings = Objects.requireNonNull(authenticationSettings);
        this.idGenerator = Objects.requireNonNull(idGenerator);
    }

    @Override
    @RunAsSystem
    @Transactional
    public void createUser(User user, String baseActivationUri) throws UsernameAlreadyExistsException, EmailAlreadyExistsException {
        List<String> activationEmailAddresses;
        if (this.userService.getUser(user.getUsername()) != null) {
            throw new UsernameAlreadyExistsException("Username '" + user.getUsername() + "' already exists.");
        }
        if (this.userService.getUserByEmail(user.getEmail()) != null) {
            throw new EmailAlreadyExistsException("Email '" + user.getEmail() + "' is already registered.");
        }
        String activationCode = this.idGenerator.generateId(IdGenerator.Strategy.SECURE_RANDOM);
        if (this.authenticationSettings.getSignUpModeration()) {
            activationEmailAddresses = this.userService.getSuEmailAddresses();
            if (activationEmailAddresses == null || activationEmailAddresses.isEmpty()) {
                throw new MolgenisDataException("Administrator account is missing required email address");
            }
        } else {
            String activationEmailAddress = user.getEmail();
            if (activationEmailAddress == null || activationEmailAddress.isEmpty()) {
                throw new MolgenisDataException("User '" + user.getUsername() + "' is missing required email address");
            }
            activationEmailAddresses = Collections.singletonList(activationEmailAddress);
        }
        user.setActivationCode(activationCode);
        user.setActive(Boolean.valueOf(false));
        this.dataService.add("sys_sec_User", (Entity)user);
        LOG.debug("created user {}", (Object)user.getUsername());
        URI activationUri = URI.create(baseActivationUri + '/' + activationCode);
        try {
            SimpleMailMessage mailMessage = new SimpleMailMessage();
            mailMessage.setTo(activationEmailAddresses.toArray(new String[0]));
            mailMessage.setSubject("User registration for " + this.appSettings.getTitle());
            mailMessage.setText(this.createActivationEmailText(user, activationUri));
            this.mailSender.send(mailMessage);
        }
        catch (MailException mce) {
            LOG.error("Could not send signup mail", (Throwable)mce);
            this.dataService.delete("sys_sec_User", (Entity)user);
            throw new MolgenisUserException("An error occurred. Please contact the administrator. You are not signed up!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("send activation email for user {} to {}", (Object)user.getUsername(), (Object)StringUtils.join(activationEmailAddresses, (char)','));
        }
    }

    @Override
    @RunAsSystem
    public void activateUser(String activationCode) {
        User user = (User)this.dataService.query("sys_sec_User", User.class).eq("active", (Object)false).and().eq("activationCode", (Object)activationCode).findOne();
        if (user == null) {
            throw new MolgenisUserException("Invalid activation code or account already activated.");
        }
        user.setActive(Boolean.valueOf(true));
        this.dataService.update("sys_sec_User", (Entity)user);
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(user.getEmail());
        mailMessage.setSubject("Your registration request for " + this.appSettings.getTitle());
        mailMessage.setText(this.createActivatedEmailText(user, this.appSettings.getTitle()));
        this.mailSender.send(mailMessage);
    }

    @Override
    @RunAsSystem
    public void changePassword(String username, String newPassword) {
        User user = (User)this.dataService.query("sys_sec_User", User.class).eq("username", (Object)username).findOne();
        if (user == null) {
            throw new MolgenisUserException(String.format("Unknown user [%s]", username));
        }
        user.setPassword(newPassword);
        user.setChangePassword(Boolean.valueOf(false));
        this.dataService.update("sys_sec_User", (Entity)user);
        LOG.info("Changed password of user [{}]", (Object)username);
    }

    @Override
    @RunAsSystem
    public void resetPassword(String userEmail) {
        User user = (User)this.dataService.query("sys_sec_User", User.class).eq("Email", (Object)userEmail).findOne();
        if (user == null) {
            throw new MolgenisUserException("Invalid email address.");
        }
        String newPassword = this.idGenerator.generateId(IdGenerator.Strategy.SHORT_SECURE_RANDOM);
        user.setPassword(newPassword);
        user.setChangePassword(Boolean.valueOf(true));
        this.dataService.update("sys_sec_User", (Entity)user);
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(user.getEmail());
        mailMessage.setSubject("Your new password request");
        mailMessage.setText(this.createPasswordResettedEmailText(newPassword));
        this.mailSender.send(mailMessage);
    }

    private String createActivationEmailText(User user, URI activationUri) {
        String strBuilder = "User registration for " + this.appSettings.getTitle() + '\n' + "User name: " + user.getUsername() + " Full name: " + user.getFirstName() + ' ' + user.getLastName() + '\n' + "In order to activate the user visit the following URL:" + '\n' + activationUri + '\n' + '\n';
        return strBuilder;
    }

    private String createActivatedEmailText(User user, String appName) {
        String strBuilder = "Dear " + user.getFirstName() + " " + user.getLastName() + ",\n\nyour registration request for " + appName + " was approved.\nYour account is now active.\n";
        return strBuilder;
    }

    private String createPasswordResettedEmailText(String newPassword) {
        String strBuilder = "Somebody, probably you, requested a new password for " + this.appSettings.getTitle() + ".\nThe new password is: " + newPassword + '\n' + "Note: we strongly recommend you reset your password after log-in!";
        return strBuilder;
    }
}

