/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import javax.servlet.Filter;
import org.molgenis.data.DataService;
import org.molgenis.data.security.auth.TokenFactory;
import org.molgenis.data.security.auth.UserFactory;
import org.molgenis.data.security.user.UserService;
import org.molgenis.security.AjaxAwareInvalidSessionStrategy;
import org.molgenis.security.AjaxAwareLoginUrlAuthenticationEntryPoint;
import org.molgenis.security.MolgenisChangePasswordFilter;
import org.molgenis.security.core.MolgenisPasswordEncoder;
import org.molgenis.security.core.token.TokenService;
import org.molgenis.security.google.GoogleAuthenticationProcessingFilter;
import org.molgenis.security.settings.AuthenticationSettings;
import org.molgenis.security.token.DataServiceTokenService;
import org.molgenis.security.token.TokenAuthenticationFilter;
import org.molgenis.security.token.TokenAuthenticationProvider;
import org.molgenis.security.token.TokenGenerator;
import org.molgenis.security.twofactor.auth.RecoveryAuthenticationProvider;
import org.molgenis.security.twofactor.auth.RecoveryAuthenticationProviderImpl;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationFilter;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationProvider;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationProviderImpl;
import org.molgenis.security.twofactor.service.OtpService;
import org.molgenis.security.twofactor.service.RecoveryService;
import org.molgenis.security.twofactor.service.TwoFactorAuthenticationService;
import org.molgenis.security.user.MolgenisUserDetailsChecker;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.security.user.UserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchyAuthoritiesMapper;
import org.springframework.security.access.intercept.RunAsImplAuthenticationProvider;
import org.springframework.security.access.vote.RoleHierarchyVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.authentication.switchuser.SwitchUserFilter;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.CacheControlHeadersWriter;
import org.springframework.security.web.header.writers.DelegatingRequestMatcherHeaderWriter;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public abstract class MolgenisWebAppSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String ANONYMOUS_AUTHENTICATION_KEY = "anonymousAuthenticationKey";
    @Autowired
    private DataService dataService;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthenticationSettings authenticationSettings;
    @Autowired
    private TokenFactory tokenFactory;
    @Autowired
    private UserFactory userFactory;
    @Autowired
    private OtpService otpService;
    @Autowired
    private TwoFactorAuthenticationService twoFactorAuthenticationService;
    @Autowired
    private RecoveryService recoveryService;
    @Autowired
    private UserAccountService userAccountService;

    protected void configure(HttpSecurity http) throws Exception {
        NegatedRequestMatcher matcher = new NegatedRequestMatcher((RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/css/**"), new AntPathRequestMatcher("/js/**"), new AntPathRequestMatcher("/img/**"), new AntPathRequestMatcher("/fonts/**")}));
        DelegatingRequestMatcherHeaderWriter cacheControlHeaderWriter = new DelegatingRequestMatcherHeaderWriter((RequestMatcher)matcher, (HeaderWriter)new CacheControlHeadersWriter());
        http.sessionManagement().invalidSessionStrategy(this.invalidSessionStrategy());
        ((HttpSecurity)http.cors().and()).headers().contentTypeOptions().and().xssProtection().and().httpStrictTransportSecurity().and().frameOptions().and().addHeaderWriter((HeaderWriter)cacheControlHeaderWriter);
        http.addFilterBefore((Filter)this.anonymousAuthFilter(), AnonymousAuthenticationFilter.class);
        http.authenticationProvider((AuthenticationProvider)this.anonymousAuthenticationProvider());
        http.authenticationProvider(this.tokenAuthenticationProvider());
        http.authenticationProvider(this.runAsAuthenticationProvider());
        http.addFilterBefore(this.tokenAuthenticationFilter(), AnonymousAuthenticationFilter.class);
        http.addFilterBefore(this.googleAuthenticationProcessingFilter(), TokenAuthenticationFilter.class);
        http.addFilterAfter(this.changePasswordFilter(), SwitchUserFilter.class);
        http.addFilterAfter((Filter)this.twoFactorAuthenticationFilter(), MolgenisChangePasswordFilter.class);
        http.authenticationProvider((AuthenticationProvider)this.twoFactorAuthenticationProvider());
        http.authenticationProvider((AuthenticationProvider)this.recoveryAuthenticationProvider());
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = http.authorizeRequests();
        this.configureUrlAuthorization(expressionInterceptUrlRegistry);
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(new String[]{"/login"})).permitAll().antMatchers(new String[]{"/2fa/**"})).permitAll().antMatchers(new String[]{"/login/google"})).permitAll().antMatchers(new String[]{"/beacon/**"})).permitAll().antMatchers(new String[]{"/logo/**"})).permitAll().antMatchers(new String[]{"/molgenis.py"})).permitAll().antMatchers(new String[]{"/molgenis.R"})).permitAll().antMatchers(new String[]{"/account/password/change"})).authenticated().antMatchers(new String[]{"/account/**"})).permitAll().antMatchers(new String[]{"/swagger/**"})).permitAll().antMatchers(new String[]{"/css/**"})).permitAll().antMatchers(new String[]{"/img/**"})).permitAll().antMatchers(new String[]{"/js/**"})).permitAll().antMatchers(new String[]{"/fonts/**"})).permitAll().antMatchers(new String[]{"/html/**"})).permitAll().antMatchers(new String[]{"/plugin/void/**"})).permitAll().antMatchers(new String[]{"/api/**"})).permitAll().antMatchers(new String[]{"/webjars/**"})).permitAll().antMatchers(new String[]{"/search"})).permitAll().antMatchers(new String[]{"/captcha"})).permitAll().antMatchers(new String[]{"/dataindexerstatus"})).authenticated().antMatchers(new String[]{"/permission/**/read/**"})).permitAll().antMatchers(new String[]{"/permission/**/write/**"})).permitAll().antMatchers(new String[]{"/scripts/**/run"})).authenticated().antMatchers(new String[]{"/scripts/**/start"})).authenticated().antMatchers(new String[]{"/files/**"})).permitAll().antMatchers(new String[]{"/apps/**"})).permitAll().anyRequest()).denyAll().and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint()).and()).formLogin().loginPage("/login").failureUrl("/login?error")).and()).logout().deleteCookies(new String[]{"JSESSIONID"}).addLogoutHandler((req, res, auth) -> {
            if (req.getSession(false) != null && req.getSession().getAttribute("continueWithUnsupportedBrowser") != null) {
                req.setAttribute("continueWithUnsupportedBrowser", (Object)true);
            }
        }).logoutSuccessHandler((req, res, auth) -> {
            StringBuilder logoutSuccessUrl = new StringBuilder("/");
            if (req.getAttribute("continueWithUnsupportedBrowser") != null) {
                logoutSuccessUrl.append("?continueWithUnsupportedBrowser=true");
            }
            SimpleUrlLogoutSuccessHandler logoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
            logoutSuccessHandler.setDefaultTargetUrl(logoutSuccessUrl.toString());
            logoutSuccessHandler.onLogoutSuccess(req, res, auth);
        }).and()).csrf().disable();
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/css/**"})).antMatchers(new String[]{"/img/**"})).antMatchers(new String[]{"/js/**"})).antMatchers(new String[]{"/fonts/**"});
    }

    @Bean
    public AuthenticationProvider runAsAuthenticationProvider() {
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        provider.setKey("Job Execution");
        return provider;
    }

    protected abstract void configureUrlAuthorization(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry var1);

    protected abstract RoleHierarchy roleHierarchy();

    @Bean
    public AnonymousAuthenticationFilter anonymousAuthFilter() {
        return new AnonymousAuthenticationFilter(ANONYMOUS_AUTHENTICATION_KEY, (Object)"anonymous", AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    }

    @Bean
    public AnonymousAuthenticationProvider anonymousAuthenticationProvider() {
        return new AnonymousAuthenticationProvider(ANONYMOUS_AUTHENTICATION_KEY);
    }

    @Bean
    public TokenService tokenService() {
        return new DataServiceTokenService(new TokenGenerator(), this.dataService, this.userDetailsService(), this.tokenFactory);
    }

    @Bean
    public AuthenticationProvider tokenAuthenticationProvider() {
        return new TokenAuthenticationProvider(this.tokenService(), this.userDetailsChecker());
    }

    @Bean
    public Filter tokenAuthenticationFilter() {
        return new TokenAuthenticationFilter(this.tokenAuthenticationProvider());
    }

    @Bean
    public GooglePublicKeysManager googlePublicKeysManager() {
        NetHttpTransport transport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        return new GooglePublicKeysManager((HttpTransport)transport, (JsonFactory)jsonFactory);
    }

    @Bean
    public Filter googleAuthenticationProcessingFilter() throws Exception {
        GoogleAuthenticationProcessingFilter googleAuthenticationProcessingFilter = new GoogleAuthenticationProcessingFilter(this.googlePublicKeysManager(), this.dataService, this.userDetailsService(), this.authenticationSettings, this.userFactory);
        googleAuthenticationProcessingFilter.setAuthenticationManager(this.authenticationManagerBean());
        return googleAuthenticationProcessingFilter;
    }

    @Bean
    public Filter changePasswordFilter() {
        return new MolgenisChangePasswordFilter(this.userService, this.redirectStrategy());
    }

    @Bean
    public TwoFactorAuthenticationFilter twoFactorAuthenticationFilter() {
        return new TwoFactorAuthenticationFilter(this.authenticationSettings, this.twoFactorAuthenticationService, this.redirectStrategy(), this.userAccountService);
    }

    @Bean
    public TwoFactorAuthenticationProvider twoFactorAuthenticationProvider() {
        return new TwoFactorAuthenticationProviderImpl(this.twoFactorAuthenticationService, this.otpService, this.recoveryService);
    }

    @Bean
    public RecoveryAuthenticationProvider recoveryAuthenticationProvider() {
        return new RecoveryAuthenticationProviderImpl(this.recoveryService);
    }

    @Bean
    public RedirectStrategy redirectStrategy() {
        return new DefaultRedirectStrategy();
    }

    @Bean
    public RoleHierarchy roleHierarchyBean() {
        return this.roleHierarchy();
    }

    @Bean
    public RoleVoter roleVoter() {
        return new RoleHierarchyVoter(this.roleHierarchy());
    }

    @Bean
    public GrantedAuthoritiesMapper roleHierarchyAuthoritiesMapper() {
        return new RoleHierarchyAuthoritiesMapper(this.roleHierarchy());
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new MolgenisPasswordEncoder(new BCryptPasswordEncoder());
    }

    @Bean
    protected UserDetailsService userDetailsService() {
        return new UserDetailsService(this.dataService, this.roleHierarchyAuthoritiesMapper());
    }

    @Bean
    public org.springframework.security.core.userdetails.UserDetailsService userDetailsServiceBean() throws Exception {
        return this.userDetailsService();
    }

    @Bean
    public UserDetailsChecker userDetailsChecker() {
        return new MolgenisUserDetailsChecker();
    }

    protected void configure(AuthenticationManagerBuilder auth) {
        try {
            DaoAuthenticationProvider authenticationProvider = new DaoAuthenticationProvider();
            authenticationProvider.setPasswordEncoder(this.passwordEncoder());
            authenticationProvider.setUserDetailsService(this.userDetailsServiceBean());
            authenticationProvider.setPreAuthenticationChecks(this.userDetailsChecker());
            auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint authenticationEntryPoint() {
        return new AjaxAwareLoginUrlAuthenticationEntryPoint("/login");
    }

    @Bean
    public InvalidSessionStrategy invalidSessionStrategy() {
        return new AjaxAwareInvalidSessionStrategy("/login?expired");
    }

    @Bean
    public HttpSessionEventPublisher httpSessionEventPublisher() {
        return new HttpSessionEventPublisher();
    }
}

