/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.jdbc;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import javax.sql.DataSource;
import org.molgenis.data.config.DataSourceConfig;
import org.molgenis.data.transaction.TransactionListener;
import org.molgenis.data.transaction.TransactionManager;
import org.molgenis.security.NoOpAuditLogger;
import org.molgenis.security.acl.AclCacheTransactionListener;
import org.molgenis.security.acl.BitMaskPermissionGrantingStrategy;
import org.molgenis.security.acl.MutableAclClassService;
import org.molgenis.security.acl.MutableAclClassServiceImpl;
import org.molgenis.security.acl.TransactionalJdbcMutableAclService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.acls.AclPermissionEvaluator;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclAuthorizationStrategyImpl;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.domain.SpringCacheBasedAclCache;
import org.springframework.security.acls.jdbc.AclClassIdUtils;
import org.springframework.security.acls.jdbc.BasicLookupStrategy;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

@Configuration
@Import(value={DataSourceConfig.class})
public class AclConfig {
    private final DataSource dataSource;
    private final TransactionManager transactionManager;
    @Autowired
    JdbcTemplate jdbcTemplate;

    public AclConfig(DataSource dataSource, TransactionManager transactionManager) {
        this.dataSource = Objects.requireNonNull(dataSource);
        this.transactionManager = Objects.requireNonNull(transactionManager);
    }

    @Bean
    public AuditLogger auditLogger() {
        return new NoOpAuditLogger();
    }

    @Bean
    public PermissionGrantingStrategy permissionGrantingStrategy() {
        return new BitMaskPermissionGrantingStrategy(this.auditLogger());
    }

    @Bean
    public AclAuthorizationStrategy aclAuthorizationStrategy() {
        SimpleGrantedAuthority gaTakeOwnership = new SimpleGrantedAuthority("ROLE_ACL_TAKE_OWNERSHIP");
        SimpleGrantedAuthority gaModifyAuditing = new SimpleGrantedAuthority("ROLE_ACL_MODIFY_AUDITING");
        SimpleGrantedAuthority gaGeneralChanges = new SimpleGrantedAuthority("ROLE_ACL_GENERAL_CHANGES");
        return new AclAuthorizationStrategyImpl(new GrantedAuthority[]{gaTakeOwnership, gaModifyAuditing, gaGeneralChanges});
    }

    @Bean
    public AclCache aclCache() {
        CaffeineCache cache = new CaffeineCache("aclCache", Caffeine.newBuilder().maximumSize(10000L).build());
        return new SpringCacheBasedAclCache((Cache)cache, this.permissionGrantingStrategy(), this.aclAuthorizationStrategy());
    }

    @Bean
    public AclCacheTransactionListener aclCacheTransactionListener() {
        AclCacheTransactionListener aclCacheTransactionListener = new AclCacheTransactionListener(this.aclCache(), this.mutableAclClassService());
        this.transactionManager.addTransactionListener((TransactionListener)aclCacheTransactionListener);
        return aclCacheTransactionListener;
    }

    @Bean
    public MutableAclClassService mutableAclClassService() {
        return new MutableAclClassServiceImpl(this.jdbcTemplate, this.aclCache());
    }

    @Bean
    public AclClassIdUtils aclClassIdUtils() {
        AclClassIdUtils aclClassIdUtils = new AclClassIdUtils();
        aclClassIdUtils.setConversionService((ConversionService)new DefaultConversionService());
        return aclClassIdUtils;
    }

    @Bean
    public LookupStrategy lookupStrategy() {
        BasicLookupStrategy basicLookupStrategy = new BasicLookupStrategy(this.dataSource, this.aclCache(), this.aclAuthorizationStrategy(), this.permissionGrantingStrategy());
        basicLookupStrategy.setAclClassIdSupported(true);
        basicLookupStrategy.setAclClassIdUtils(this.aclClassIdUtils());
        return basicLookupStrategy;
    }

    @Bean
    public MutableAclService aclService() {
        TransactionalJdbcMutableAclService aclService = new TransactionalJdbcMutableAclService(this.dataSource, this.lookupStrategy(), this.aclCache());
        aclService.setAclClassIdSupported(true);
        aclService.setAclClassIdUtils(this.aclClassIdUtils());
        aclService.setClassIdentityQuery("select currval(pg_get_serial_sequence('acl_class', 'id'))");
        aclService.setSidIdentityQuery("select currval(pg_get_serial_sequence('acl_sid', 'id'))");
        aclService.setObjectIdentityPrimaryKeyQuery("select acl_object_identity.id from acl_object_identity, acl_class where acl_object_identity.object_id_class = acl_class.id and acl_class.class=? and acl_object_identity.object_id_identity = ?::varchar");
        aclService.setFindChildrenQuery("select obj.object_id_identity as obj_id, class.class as class, class.class_id_type as class_id_type from acl_object_identity obj, acl_object_identity parent, acl_class class where obj.parent_object = parent.id and obj.object_id_class = class.id and parent.object_id_identity = ?::varchar and parent.object_id_class = (select id FROM acl_class where acl_class.class = ?)");
        return aclService;
    }

    @Bean
    public AclPermissionEvaluator aclPermissionEvaluator() {
        return new AclPermissionEvaluator((AclService)this.aclService());
    }
}

