/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.session.SimpleRedirectInvalidSessionStrategy;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class AjaxAwareInvalidSessionStrategy
implements InvalidSessionStrategy {
    private static final RequestMatcher REQUEST_MATCHER_XML_HTTP_REQUEST = new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest");
    private final SimpleRedirectInvalidSessionStrategy simpleRedirectInvalidSessionStrategy;

    AjaxAwareInvalidSessionStrategy(String invalidSessionUrl) {
        Objects.requireNonNull(invalidSessionUrl);
        this.simpleRedirectInvalidSessionStrategy = new SimpleRedirectInvalidSessionStrategy(invalidSessionUrl);
    }

    public void onInvalidSessionDetected(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (REQUEST_MATCHER_XML_HTTP_REQUEST.matches(request)) {
            response.sendError(401);
        } else {
            this.simpleRedirectInvalidSessionStrategy.onInvalidSessionDetected(request, response);
        }
    }
}

