/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.freemarker;

import com.google.common.collect.Lists;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.molgenis.data.DataConverter;
import org.molgenis.data.plugin.model.PluginIdentity;
import org.molgenis.data.plugin.model.PluginPermission;
import org.molgenis.data.security.EntityTypeIdentity;
import org.molgenis.data.security.EntityTypePermission;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.springframework.security.acls.model.ObjectIdentity;

public abstract class PermissionDirective
implements TemplateDirectiveModel {
    private final UserPermissionEvaluator permissionService;

    PermissionDirective(UserPermissionEvaluator permissionService) {
        this.permissionService = permissionService;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String entityTypeIdValue = DataConverter.toString(params.get("entityTypeId"));
        String pluginIdValue = DataConverter.toString(params.get("plugin"));
        String permissionValue = DataConverter.toString(params.get("permission"));
        if (permissionValue == null) {
            throw new TemplateModelException("Missing 'permission' parameter");
        }
        if (entityTypeIdValue == null && pluginIdValue == null) {
            throw new TemplateModelException("Missing 'entityTypeId' and/or 'plugin' parameter");
        }
        boolean hasPermission = true;
        if (entityTypeIdValue != null) {
            hasPermission = this.permissionService.hasPermission((ObjectIdentity)new EntityTypeIdentity(entityTypeIdValue), this.toEntityTypePermissions(permissionValue));
        }
        if (pluginIdValue != null && hasPermission) {
            hasPermission = this.permissionService.hasPermission((ObjectIdentity)new PluginIdentity(pluginIdValue), (Permission)PluginPermission.VIEW_PLUGIN);
        }
        this.execute(hasPermission, env, body);
    }

    protected abstract void execute(boolean var1, Environment var2, TemplateDirectiveBody var3) throws TemplateException, IOException;

    private List<Permission> toEntityTypePermissions(String permission) {
        switch (permission) {
            case "COUNT": {
                return Lists.newArrayList((Object[])new Permission[]{EntityTypePermission.COUNT_DATA});
            }
            case "READ": {
                return Lists.newArrayList((Object[])new Permission[]{EntityTypePermission.READ_METADATA, EntityTypePermission.READ_DATA});
            }
            case "WRITE": {
                return Lists.newArrayList((Object[])new Permission[]{EntityTypePermission.READ_METADATA, EntityTypePermission.UPDATE_DATA});
            }
            case "WRITEMETA": {
                return Lists.newArrayList((Object[])new Permission[]{EntityTypePermission.UPDATE_METADATA});
            }
            case "NONE": {
                throw new IllegalArgumentException(String.format("Permission evaluation for permission '%s' not allowed", permission));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown permission '%s'", permission));
    }
}

