/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.settings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.security.oidc.model.OidcClient;
import org.molgenis.security.oidc.model.OidcClientMetadata;
import org.molgenis.security.settings.AuthenticationSettings;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationSetting;
import org.molgenis.settings.DefaultSettingsEntity;
import org.molgenis.settings.DefaultSettingsEntityType;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationSettingsImpl
extends DefaultSettingsEntity
implements AuthenticationSettings {
    private static final long serialVersionUID = 1L;
    private static final String ID = "auth";

    public AuthenticationSettingsImpl() {
        super(ID);
    }

    @Override
    public boolean getSignUp() {
        Boolean value = this.getBoolean("signup");
        return value != null ? value : false;
    }

    @Override
    public void setSignUp(boolean signUp) {
        this.set("signup", signUp);
    }

    @Override
    public boolean getSignUpModeration() {
        Boolean value = this.getBoolean("signup_moderation");
        return value != null ? value : false;
    }

    @Override
    public void setOidcClients(List<OidcClient> oidcClients) {
        this.set("oidcClients", oidcClients);
    }

    @Override
    public Iterable<OidcClient> getOidcClients() {
        boolean enableOidc = this.getSignUp() && !this.getSignUpModeration();
        return enableOidc ? this.getEntities("oidcClients", OidcClient.class) : Collections.emptyList();
    }

    @Override
    public void setSignUpModeration(boolean signUpModeration) {
        this.set("signup_moderation", signUpModeration);
    }

    @Override
    public void setTwoFactorAuthentication(TwoFactorAuthenticationSetting twoFactorAuthentication) {
        this.set("sign_in_2fa", twoFactorAuthentication.getLabel());
    }

    @Override
    public TwoFactorAuthenticationSetting getTwoFactorAuthentication() {
        return TwoFactorAuthenticationSetting.fromLabel(this.getString("sign_in_2fa"));
    }

    @Component
    public static class Meta
    extends DefaultSettingsEntityType {
        private static final String SIGNUP = "signup";
        private static final String SIGNUP_MODERATION = "signup_moderation";
        private static final String OIDC_CLIENTS = "oidcClients";
        private static final String SIGN_IN_2FA = "sign_in_2fa";
        private static final boolean DEFAULT_SIGNUP = false;
        private static final boolean DEFAULT_SIGNUP_MODERATION = true;
        private final OidcClientMetadata oidcClientMetadata;

        public Meta(OidcClientMetadata oidcClientMetadata) {
            super(AuthenticationSettingsImpl.ID);
            this.oidcClientMetadata = Objects.requireNonNull(oidcClientMetadata);
        }

        public void init() {
            super.init();
            this.setLabel("Authentication settings");
            this.setDescription("Settings for authentication methods and user sign-up.");
            this.addAttribute(SIGNUP, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(false)).setLabel("Allow users to sign up");
            this.addAttribute(SIGNUP_MODERATION, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Sign up moderation").setDescription("Admins must accept sign up requests before account activation").setVisibleExpression("$('signup').eq(true).value()");
            this.addAttribute(OIDC_CLIENTS, new EntityType.AttributeRole[0]).setDataType(AttributeType.MREF).setRefEntity((EntityType)this.oidcClientMetadata).setLabel("Authentication servers").setDescription("OpenID Connect authentication servers").setVisibleExpression("$('signup').eq(true).value() && $('signup_moderation').eq(false).value()");
            this.addAttribute(SIGN_IN_2FA, new EntityType.AttributeRole[0]).setDataType(AttributeType.ENUM).setNillable(false).setDefaultValue(TwoFactorAuthenticationSetting.DISABLED.getLabel()).setEnumOptions(Arrays.asList(TwoFactorAuthenticationSetting.DISABLED.getLabel(), TwoFactorAuthenticationSetting.ENABLED.getLabel(), TwoFactorAuthenticationSetting.ENFORCED.getLabel())).setLabel("Two Factor Authentication").setDescription("Enable or enforce users to sign in with Google Authenticator.").setValidationExpression(Meta.getSignIn2FAValidationExpression());
        }

        private static String getSignIn2FAValidationExpression() {
            return String.format("$('%s').eq('%s').or($('%s').not()).or($('%s')).value()", SIGN_IN_2FA, TwoFactorAuthenticationSetting.DISABLED.getLabel(), SIGNUP, SIGNUP_MODERATION);
        }
    }
}

