/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.twofactor.auth;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.security.settings.AuthenticationSettings;
import org.molgenis.security.token.RestAuthenticationToken;
import org.molgenis.security.twofactor.auth.RecoveryAuthenticationToken;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationSetting;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationToken;
import org.molgenis.security.twofactor.service.TwoFactorAuthenticationService;
import org.molgenis.security.user.UserAccountService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.web.filter.OncePerRequestFilter;

public class TwoFactorAuthenticationFilter
extends OncePerRequestFilter {
    private final RedirectStrategy redirectStrategy;
    private final UserAccountService userAccountService;
    private final TwoFactorAuthenticationService twoFactorAuthenticationService;
    private final AuthenticationSettings authenticationSettings;

    public TwoFactorAuthenticationFilter(AuthenticationSettings authenticationSettings, TwoFactorAuthenticationService twoFactorAuthenticationService, RedirectStrategy redirectStrategy, UserAccountService userAccountService) {
        this.authenticationSettings = Objects.requireNonNull(authenticationSettings);
        this.twoFactorAuthenticationService = Objects.requireNonNull(twoFactorAuthenticationService);
        this.redirectStrategy = Objects.requireNonNull(redirectStrategy);
        this.userAccountService = Objects.requireNonNull(userAccountService);
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.isUserShouldTwoFactorAuthenticate() && SecurityUtils.currentUserIsAuthenticated() && this.isNotProtected(httpServletRequest.getRequestURI()) && this.isInsufficientlyAuthenticated()) {
            this.redirectToTwoFactorAuthenticationController(httpServletRequest, httpServletResponse);
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private boolean isUserShouldTwoFactorAuthenticate() {
        return this.authenticationSettings.getTwoFactorAuthentication() != TwoFactorAuthenticationSetting.DISABLED && (this.authenticationSettings.getTwoFactorAuthentication() == TwoFactorAuthenticationSetting.ENFORCED || this.userAccountService.getCurrentUser().isTwoFactorAuthentication());
    }

    private boolean isNotProtected(String requestURI) {
        return !requestURI.startsWith("/2fa") && !requestURI.equalsIgnoreCase("/account/password/change");
    }

    private void redirectToTwoFactorAuthenticationController(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.twoFactorAuthenticationService.isConfiguredForUser()) {
            this.redirectStrategy.sendRedirect(httpServletRequest, httpServletResponse, "/2fa/authenticate");
        } else {
            this.redirectStrategy.sendRedirect(httpServletRequest, httpServletResponse, "/2fa/activation");
        }
    }

    private boolean isInsufficientlyAuthenticated() {
        return !this.isUserTwoFactorAuthenticated() && !this.hasAuthenticatedMolgenisToken() && !this.isUserRecoveryAuthenticated();
    }

    private boolean isUserTwoFactorAuthenticated() {
        boolean isTwoFactorAuthenticated = false;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof TwoFactorAuthenticationToken) {
            isTwoFactorAuthenticated = authentication.isAuthenticated();
        }
        return isTwoFactorAuthenticated;
    }

    private boolean isUserRecoveryAuthenticated() {
        boolean isRecoveryAuthenticated = false;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof RecoveryAuthenticationToken) {
            isRecoveryAuthenticated = authentication.isAuthenticated();
        }
        return isRecoveryAuthenticated;
    }

    private boolean hasAuthenticatedMolgenisToken() {
        boolean hasAuthenticatedMolgenisToken = false;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof RestAuthenticationToken) {
            hasAuthenticatedMolgenisToken = authentication.isAuthenticated();
        }
        return hasAuthenticatedMolgenisToken;
    }
}

