/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.oidc.model;

import java.util.Objects;
import org.molgenis.data.AbstractSystemRepositoryDecoratorFactory;
import org.molgenis.data.Repository;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.security.oidc.ResettableOAuth2AuthorizedClientService;
import org.molgenis.security.oidc.model.OidcClient;
import org.molgenis.security.oidc.model.OidcClientMetadata;
import org.molgenis.security.oidc.model.OidcClientRepositoryDecorator;
import org.springframework.stereotype.Component;

@Component
public class OidcClientRepositoryDecoratorFactory
extends AbstractSystemRepositoryDecoratorFactory<OidcClient, OidcClientMetadata> {
    private final ResettableOAuth2AuthorizedClientService oAuth2AuthorizedClientService;

    public OidcClientRepositoryDecoratorFactory(OidcClientMetadata oidcClientMetadata, ResettableOAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
        super((SystemEntityType)oidcClientMetadata);
        this.oAuth2AuthorizedClientService = Objects.requireNonNull(oAuth2AuthorizedClientService);
    }

    public Repository<OidcClient> createDecoratedRepository(Repository<OidcClient> repository) {
        return new OidcClientRepositoryDecorator(repository, this.oAuth2AuthorizedClientService);
    }
}

