/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.molgenis.security.permission.SecurityContextRegistryImpl;
import org.springframework.stereotype.Component;

@Component
public class SessionMetrics
implements MeterBinder {
    private final SecurityContextRegistryImpl sessions;

    SessionMetrics(SecurityContextRegistryImpl sessions) {
        this.sessions = Objects.requireNonNull(sessions);
    }

    public void bindTo(@Nonnull MeterRegistry meterRegistry) {
        Gauge.builder((String)"spring.sessions", (Object)this.sessions, SessionMetrics::getSessions).description("The number of sessions, including expired sessions").register(meterRegistry);
    }

    private static long getSessions(SecurityContextRegistryImpl sessions) {
        return sessions.getSecurityContexts().count();
    }
}

