/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import org.molgenis.security.permission.SecurityContextRegistry;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.session.HttpSessionCreatedEvent;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.stereotype.Component;

@Component
public class SecurityContextRegistryImpl
implements SecurityContextRegistry {
    private final ConcurrentMap<String, HttpSession> httpSessionMap = new ConcurrentHashMap<String, HttpSession>();

    SecurityContextRegistryImpl() {
    }

    @Override
    public SecurityContext getSecurityContext(String sessionId) {
        HttpSession httpSession = (HttpSession)this.httpSessionMap.get(sessionId);
        if (httpSession == null) {
            return null;
        }
        return this.getSecurityContext(httpSession);
    }

    @Override
    public Stream<SecurityContext> getSecurityContexts() {
        return this.httpSessionMap.values().stream().map(this::getSecurityContext).filter(Objects::nonNull);
    }

    private SecurityContext getSecurityContext(HttpSession httpSession) {
        Object securityContext;
        try {
            securityContext = httpSession.getAttribute("SPRING_SECURITY_CONTEXT");
        }
        catch (IllegalStateException e) {
            return null;
        }
        if (securityContext == null) {
            return null;
        }
        if (!(securityContext instanceof SecurityContext)) {
            throw new IllegalStateException(String.format("Session attribute '%s' is of type '%s' instead of '%s'", "SPRING_SECURITY_CONTEXT", securityContext.getClass().getSimpleName(), SecurityContext.class.getSimpleName()));
        }
        return (SecurityContext)securityContext;
    }

    @EventListener
    public void handleHttpSessionCreatedEvent(HttpSessionCreatedEvent httpSessionCreatedEvent) {
        HttpSession session = httpSessionCreatedEvent.getSession();
        this.httpSessionMap.put(session.getId(), session);
    }

    @EventListener
    public void handleHttpSessionDestroyedEvent(HttpSessionDestroyedEvent httpSessionDestroyedEvent) {
        String sessionId = httpSessionDestroyedEvent.getId();
        this.httpSessionMap.remove(sessionId);
    }
}

