/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.oidc;

import java.util.HashSet;
import java.util.Objects;
import org.molgenis.data.security.auth.User;
import org.molgenis.security.oidc.MappedOidcUser;
import org.molgenis.security.oidc.OidcUserMapper;
import org.molgenis.security.user.UserDetailsService;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class MappedOidcUserService
extends OidcUserService {
    private final OidcUserMapper oidcUserMapper;
    private final UserDetailsService userDetailsService;

    public MappedOidcUserService(OidcUserMapper oidcUserMapper, UserDetailsService userDetailsService) {
        this.oidcUserMapper = Objects.requireNonNull(oidcUserMapper);
        this.userDetailsService = Objects.requireNonNull(userDetailsService);
    }

    public MappedOidcUser loadUser(OidcUserRequest userRequest) {
        OidcUser oidcUser = super.loadUser(userRequest);
        return this.createOidcUser(oidcUser, userRequest);
    }

    private MappedOidcUser createOidcUser(OidcUser oidcUser, OidcUserRequest userRequest) {
        User user = this.oidcUserMapper.toUser(oidcUser, userRequest);
        String userNameAttributeName = this.getUserNameAttributeName(userRequest);
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>(this.userDetailsService.getAuthorities(user));
        return new MappedOidcUser(authorities, oidcUser.getIdToken(), oidcUser.getUserInfo(), userNameAttributeName, user.getUsername());
    }

    private String getUserNameAttributeName(OidcUserRequest userRequest) {
        return userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
    }
}

