/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.account;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.security.auth.PasswordResetToken;
import org.molgenis.data.security.auth.PasswordResetTokenFactory;
import org.molgenis.data.security.auth.User;
import org.molgenis.security.account.ExpiredPasswordResetTokenException;
import org.molgenis.security.account.InvalidPasswordResetTokenException;
import org.molgenis.security.account.PasswordResetTokenCreationException;
import org.molgenis.security.account.PasswordResetTokenRepository;
import org.molgenis.security.account.UnknownPasswordResetTokenException;
import org.molgenis.security.token.TokenGenerator;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class PasswordResetTokenRepositoryImpl
implements PasswordResetTokenRepository {
    private final PasswordResetTokenFactory passwordResetTokenFactory;
    private final PasswordEncoder passwordEncoder;
    private final DataService dataService;
    private final TokenGenerator tokenGenerator;

    PasswordResetTokenRepositoryImpl(PasswordResetTokenFactory passwordResetTokenFactory, PasswordEncoder passwordEncoder, DataService dataService) {
        this.passwordResetTokenFactory = Objects.requireNonNull(passwordResetTokenFactory);
        this.passwordEncoder = Objects.requireNonNull(passwordEncoder);
        this.dataService = Objects.requireNonNull(dataService);
        this.tokenGenerator = new TokenGenerator();
    }

    @Override
    @Transactional
    public String createToken(User user) {
        if (!user.isActive().booleanValue()) {
            throw new PasswordResetTokenCreationException();
        }
        this.deleteTokenIfExists(user);
        return this.addPasswordResetToken(user);
    }

    @Override
    @Transactional(readOnly=true)
    public void validateToken(User user, String token) {
        PasswordResetToken passwordResetToken = this.getPasswordResetToken(user, token);
        if (passwordResetToken.getExpirationDate().isBefore(Instant.now())) {
            throw new ExpiredPasswordResetTokenException(passwordResetToken);
        }
    }

    @Override
    @Transactional
    public void deleteToken(User user, String token) {
        PasswordResetToken passwordResetToken = this.getPasswordResetToken(user, token);
        this.dataService.delete("sys_sec_PasswordResetToken", (Entity)passwordResetToken);
    }

    private void deleteTokenIfExists(User user) {
        this.getPasswordResetToken(user).ifPresent(passwordResetToken -> this.dataService.delete("sys_sec_PasswordResetToken", (Entity)passwordResetToken));
    }

    private PasswordResetToken getPasswordResetToken(User user, String token) {
        Optional<PasswordResetToken> optionalPasswordResetToken = this.getPasswordResetToken(user);
        if (!optionalPasswordResetToken.isPresent()) {
            throw new UnknownPasswordResetTokenException();
        }
        PasswordResetToken passwordResetToken = optionalPasswordResetToken.get();
        if (!this.passwordEncoder.matches((CharSequence)token, passwordResetToken.getToken())) {
            throw new InvalidPasswordResetTokenException(passwordResetToken);
        }
        return passwordResetToken;
    }

    private Optional<PasswordResetToken> getPasswordResetToken(User user) {
        PasswordResetToken passwordResetToken = (PasswordResetToken)this.dataService.query("sys_sec_PasswordResetToken", PasswordResetToken.class).eq("user", (Object)user).findOne();
        return Optional.ofNullable(passwordResetToken);
    }

    private String addPasswordResetToken(User user) {
        String token = this.tokenGenerator.generateToken();
        Instant expirationDate = Instant.now().plus(2L, ChronoUnit.HOURS);
        String tokenHash = this.passwordEncoder.encode((CharSequence)token);
        PasswordResetToken passwordResetToken = (PasswordResetToken)this.passwordResetTokenFactory.create();
        passwordResetToken.setUser(user);
        passwordResetToken.setToken(tokenHash);
        passwordResetToken.setExpirationDate(expirationDate);
        this.dataService.add("sys_sec_PasswordResetToken", (Entity)passwordResetToken);
        return token;
    }
}

