/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.acl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.molgenis.security.acl.ObjectIdentityService;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;

public class ObjectIdentityServiceImpl
implements ObjectIdentityService {
    private static final String SQL_COUNT_OBJECT_IDENTITIES = "SELECT COUNT( DISTINCT acl_object_identity.object_id_identity) FROM acl_object_identity LEFT JOIN acl_class ON acl_object_identity.object_id_class = acl_class.id LEFT JOIN acl_entry ON acl_entry.acl_object_identity = acl_object_identity.id LEFT JOIN acl_sid ON acl_entry.sid = acl_sid.id";
    private static final String SQL_SELECT_OBJECT_IDENTITIES = "SELECT DISTINCT acl_object_identity.object_id_identity, acl_class.class FROM acl_object_identity LEFT JOIN acl_class ON acl_object_identity.object_id_class = acl_class.id LEFT JOIN acl_entry ON acl_entry.acl_object_identity = acl_object_identity.id LEFT JOIN acl_sid ON acl_entry.sid = acl_sid.id";
    private static final String WHERE_CLASS = " WHERE acl_class.class = :classId";
    private static final String AND_SID = " AND acl_sid.sid IN (:sids)";
    private static final String ORDER_BY = " ORDER BY acl_object_identity.object_id_identity ASC";
    private static final String PAGE = " LIMIT :limit OFFSET :offset";
    public static final Integer MAX_RESULTS = 10000;
    public static final String OBJECT_ID_IDENTITY = "object_id_identity";
    public static final String CLASS = "class";
    public static final String CLASS_ID = "classId";
    public static final String LIMIT = "limit";
    public static final String OFFSET = "offset";
    public static final String SIDS = "sids";
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedJdbcTemplate;

    public ObjectIdentityServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
    }

    ObjectIdentityServiceImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.namedJdbcTemplate = Objects.requireNonNull(jdbcTemplate);
    }

    private NamedParameterJdbcTemplate getTemplate() {
        if (this.namedJdbcTemplate == null) {
            this.namedJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        }
        return this.namedJdbcTemplate;
    }

    public List<ObjectIdentity> getObjectIdentities(String classId) {
        int rowCount = this.getNrOfObjectIdentities(classId);
        if (rowCount > MAX_RESULTS) {
            throw new UnsupportedOperationException("Unfiltered select on object identities not supported for classes with more than '" + MAX_RESULTS + "' rows.");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(CLASS_ID, classId);
        List result = this.getTemplate().queryForList("SELECT DISTINCT acl_object_identity.object_id_identity, acl_class.class FROM acl_object_identity LEFT JOIN acl_class ON acl_object_identity.object_id_class = acl_class.id LEFT JOIN acl_entry ON acl_entry.acl_object_identity = acl_object_identity.id LEFT JOIN acl_sid ON acl_entry.sid = acl_sid.id WHERE acl_class.class = :classId ORDER BY acl_object_identity.object_id_identity ASC", paramMap);
        return this.parseToStringList(result);
    }

    public Integer getNrOfObjectIdentities(String classId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(CLASS_ID, classId);
        return (Integer)this.getTemplate().queryForObject("SELECT COUNT( DISTINCT acl_object_identity.object_id_identity) FROM acl_object_identity LEFT JOIN acl_class ON acl_object_identity.object_id_class = acl_class.id LEFT JOIN acl_entry ON acl_entry.acl_object_identity = acl_object_identity.id LEFT JOIN acl_sid ON acl_entry.sid = acl_sid.id WHERE acl_class.class = :classId", paramMap, Integer.class);
    }

    public Integer getNrOfObjectIdentities(String classId, Set<Sid> sids) {
        List<String> sidStrings = this.getSidIdentifiers(sids);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(SIDS, sidStrings);
        paramMap.put(CLASS_ID, classId);
        return (Integer)this.getTemplate().queryForObject("SELECT COUNT( DISTINCT acl_object_identity.object_id_identity) FROM acl_object_identity LEFT JOIN acl_class ON acl_object_identity.object_id_class = acl_class.id LEFT JOIN acl_entry ON acl_entry.acl_object_identity = acl_object_identity.id LEFT JOIN acl_sid ON acl_entry.sid = acl_sid.id WHERE acl_class.class = :classId AND acl_sid.sid IN (:sids)", paramMap, Integer.class);
    }

    public List<ObjectIdentity> getObjectIdentities(String classId, int limit, int offset) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(CLASS_ID, classId);
        paramMap.put(LIMIT, limit);
        paramMap.put(OFFSET, offset);
        List result = this.getTemplate().queryForList("SELECT DISTINCT acl_object_identity.object_id_identity, acl_class.class FROM acl_object_identity LEFT JOIN acl_class ON acl_object_identity.object_id_class = acl_class.id LEFT JOIN acl_entry ON acl_entry.acl_object_identity = acl_object_identity.id LEFT JOIN acl_sid ON acl_entry.sid = acl_sid.id WHERE acl_class.class = :classId ORDER BY acl_object_identity.object_id_identity ASC LIMIT :limit OFFSET :offset", paramMap);
        return this.parseToStringList(result);
    }

    public List<ObjectIdentity> getObjectIdentities(String classId, Set<Sid> sids, int limit, int offset) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(SIDS, this.getSidIdentifiers(sids));
        paramMap.put(CLASS_ID, classId);
        paramMap.put(LIMIT, limit);
        paramMap.put(OFFSET, offset);
        List result = this.getTemplate().queryForList("SELECT DISTINCT acl_object_identity.object_id_identity, acl_class.class FROM acl_object_identity LEFT JOIN acl_class ON acl_object_identity.object_id_class = acl_class.id LEFT JOIN acl_entry ON acl_entry.acl_object_identity = acl_object_identity.id LEFT JOIN acl_sid ON acl_entry.sid = acl_sid.id WHERE acl_class.class = :classId AND acl_sid.sid IN (:sids) ORDER BY acl_object_identity.object_id_identity ASC LIMIT :limit OFFSET :offset", paramMap);
        return this.parseToStringList(result);
    }

    public List<ObjectIdentity> getObjectIdentities(String classId, Set<Sid> sids) {
        List result;
        int rowCount = this.getNrOfObjectIdentities(classId, sids);
        if (rowCount > MAX_RESULTS) {
            throw new UnsupportedOperationException("Unfiltered select on object identities not supported for classes with more than '" + MAX_RESULTS + "' rows.");
        }
        if (sids.isEmpty()) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put(CLASS_ID, classId);
            result = this.getTemplate().queryForList("SELECT DISTINCT acl_object_identity.object_id_identity, acl_class.class FROM acl_object_identity LEFT JOIN acl_class ON acl_object_identity.object_id_class = acl_class.id LEFT JOIN acl_entry ON acl_entry.acl_object_identity = acl_object_identity.id LEFT JOIN acl_sid ON acl_entry.sid = acl_sid.id WHERE acl_class.class = :classId ORDER BY acl_object_identity.object_id_identity ASC", paramMap);
        } else {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put(SIDS, this.getSidIdentifiers(sids));
            paramMap.put(CLASS_ID, classId);
            result = this.getTemplate().queryForList("SELECT DISTINCT acl_object_identity.object_id_identity, acl_class.class FROM acl_object_identity LEFT JOIN acl_class ON acl_object_identity.object_id_class = acl_class.id LEFT JOIN acl_entry ON acl_entry.acl_object_identity = acl_object_identity.id LEFT JOIN acl_sid ON acl_entry.sid = acl_sid.id WHERE acl_class.class = :classId AND acl_sid.sid IN (:sids) ORDER BY acl_object_identity.object_id_identity ASC", paramMap);
        }
        return this.parseToStringList(result);
    }

    private List<String> getSidIdentifiers(Set<Sid> sids) {
        ArrayList<String> sidStrings = new ArrayList<String>();
        for (Sid sid : sids) {
            sidStrings.add(this.getSidString(sid));
        }
        return sidStrings;
    }

    private List<ObjectIdentity> parseToStringList(List<Map<String, Object>> result) {
        return result.stream().map(this::parseRow).collect(Collectors.toList());
    }

    private ObjectIdentity parseRow(Map<String, Object> row) {
        return new ObjectIdentityImpl(row.get(CLASS).toString(), (Serializable)row.get(OBJECT_ID_IDENTITY));
    }

    private String getSidString(Sid sid) {
        if (sid instanceof PrincipalSid) {
            return ((PrincipalSid)sid).getPrincipal();
        }
        if (sid instanceof GrantedAuthoritySid) {
            return ((GrantedAuthoritySid)sid).getGrantedAuthority();
        }
        throw new IllegalArgumentException("Sid type should always be either PrincipalSid or GrantedAuthoritySid");
    }
}

