/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.acl;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.molgenis.security.core.SidUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.security.acls.jdbc.JdbcMutableAclService;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class TransactionalJdbcMutableAclService
extends JdbcMutableAclService {
    public TransactionalJdbcMutableAclService(DataSource dataSource, LookupStrategy lookupStrategy, AclCache aclCache) {
        super(dataSource, lookupStrategy, aclCache);
    }

    @Transactional
    public MutableAcl createAcl(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, (String)"Object Identity required");
        Sid sid = SidUtils.createSecurityContextSid();
        try {
            this.createObjectIdentity(objectIdentity, sid);
        }
        catch (DuplicateKeyException e) {
            throw new AlreadyExistsException("Object identity '" + objectIdentity + "' already exists");
        }
        Acl acl = this.readAclById(objectIdentity);
        Assert.isInstanceOf(MutableAcl.class, (Object)acl, (String)"MutableAcl should be been returned");
        return (MutableAcl)acl;
    }

    @Transactional
    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) {
        super.deleteAcl(objectIdentity, deleteChildren);
    }

    @Transactional
    public MutableAcl updateAcl(MutableAcl acl) {
        return super.updateAcl(acl);
    }

    @Transactional(readOnly=true)
    public List<ObjectIdentity> findChildren(ObjectIdentity parentIdentity) {
        return super.findChildren(parentIdentity);
    }

    @Transactional(readOnly=true)
    public Acl readAclById(ObjectIdentity object, List<Sid> sids) {
        return super.readAclById(object, sids);
    }

    @Transactional(readOnly=true)
    public Acl readAclById(ObjectIdentity object) {
        return super.readAclById(object);
    }

    @Transactional(readOnly=true)
    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects) {
        return super.readAclsById(objects);
    }

    @Transactional(readOnly=true)
    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects, List<Sid> sids) {
        return super.readAclsById(objects, sids);
    }
}

