/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.oidc;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.util.Assert;

public class ResettableOAuth2AuthorizedClientService
implements OAuth2AuthorizedClientService {
    private final Map<String, OAuth2AuthorizedClient> authorizedClients = new ConcurrentHashMap<String, OAuth2AuthorizedClient>();
    private final ClientRegistrationRepository clientRegistrationRepository;

    public ResettableOAuth2AuthorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        ClientRegistration registration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
        if (registration == null) {
            return null;
        }
        return (T)this.authorizedClients.get(this.getIdentifier(registration, principalName));
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal) {
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        this.authorizedClients.put(this.getIdentifier(authorizedClient.getClientRegistration(), principal.getName()), authorizedClient);
    }

    public void removeAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        ClientRegistration registration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
        if (registration != null) {
            this.authorizedClients.remove(this.getIdentifier(registration, principalName));
        }
    }

    private String getIdentifier(ClientRegistration registration, String principalName) {
        String identifier = "[" + registration.getRegistrationId() + "][" + principalName + "]";
        return Base64.getEncoder().encodeToString(identifier.getBytes(StandardCharsets.UTF_8));
    }

    public void reset() {
        this.authorizedClients.clear();
    }

    Map<String, OAuth2AuthorizedClient> getAuthorizedClients() {
        return this.authorizedClients;
    }
}

