/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.security.token.TokenExtractor;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;

class TokenAwareSecurityContextRepository
implements SecurityContextRepository {
    private final SecurityContextRepository tokenSecurityContextRepository;
    private final SecurityContextRepository defaultSecurityContextRepository;

    TokenAwareSecurityContextRepository(SecurityContextRepository tokenSecurityContextRepository, SecurityContextRepository defaultSecurityContextRepository) {
        this.tokenSecurityContextRepository = Objects.requireNonNull(tokenSecurityContextRepository);
        this.defaultSecurityContextRepository = Objects.requireNonNull(defaultSecurityContextRepository);
    }

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        HttpServletRequest request = requestResponseHolder.getRequest();
        return this.getSecurityContextRepository(request).loadContext(requestResponseHolder);
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        this.getSecurityContextRepository(request).saveContext(context, request, response);
    }

    public boolean containsContext(HttpServletRequest request) {
        return this.getSecurityContextRepository(request).containsContext(request);
    }

    private SecurityContextRepository getSecurityContextRepository(HttpServletRequest request) {
        boolean hasToken = TokenExtractor.getToken(request) != null;
        return hasToken ? this.tokenSecurityContextRepository : this.defaultSecurityContextRepository;
    }
}

