/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class AjaxAwareLoginUrlAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private static final RequestMatcher REQUEST_MATCHER_XML_HTTP_REQUEST = new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest");

    AjaxAwareLoginUrlAuthenticationEntryPoint(String loginFormUrl) {
        super(loginFormUrl);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (this.isPreflight(request)) {
            response.setStatus(204);
        } else if (this.isRestRequest(request)) {
            response.sendError(401);
        } else {
            super.commence(request, response, authException);
        }
    }

    private boolean isPreflight(HttpServletRequest request) {
        return "OPTIONS".equals(request.getMethod());
    }

    private boolean isRestRequest(HttpServletRequest request) {
        return REQUEST_MATCHER_XML_HTTP_REQUEST.matches(request);
    }
}

