/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.oidc;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.auth.UserFactory;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.oidc.OidcUserEmailVerificationException;
import org.molgenis.security.oidc.OidcUserMapper;
import org.molgenis.security.oidc.OidcUserMissingEmailException;
import org.molgenis.security.oidc.model.OidcClient;
import org.molgenis.security.oidc.model.OidcUserMapping;
import org.molgenis.security.oidc.model.OidcUserMappingFactory;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.transaction.annotation.Transactional;

public class OidcUserMapperImpl
implements OidcUserMapper {
    private final DataService dataService;
    private final OidcUserMappingFactory oidcUserMappingFactory;
    private final UserFactory userFactory;

    public OidcUserMapperImpl(DataService dataService, OidcUserMappingFactory oidcUserMappingFactory, UserFactory userFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.oidcUserMappingFactory = Objects.requireNonNull(oidcUserMappingFactory);
        this.userFactory = Objects.requireNonNull(userFactory);
    }

    @Override
    @Transactional
    public User toUser(OidcUser oidcUser, OidcUserRequest userRequest) {
        this.verifyOidcUser(oidcUser);
        return (User)RunAsSystemAspect.runAsSystem(() -> this.getUser(oidcUser, userRequest).orElseGet(() -> this.createUserMapping(oidcUser, userRequest)));
    }

    private void verifyOidcUser(OidcUser oidcUser) {
        if (oidcUser.getEmail() == null) {
            throw new OidcUserMissingEmailException(oidcUser);
        }
        Boolean emailVerified = oidcUser.getEmailVerified();
        if (emailVerified != null && !emailVerified.booleanValue()) {
            throw new OidcUserEmailVerificationException(oidcUser);
        }
    }

    private Optional<User> getUser(OidcUser oidcUser, OidcUserRequest userRequest) {
        OidcUserMapping oidcUserMapping = (OidcUserMapping)this.dataService.query("sys_sec_oidc_OidcUserMapping", OidcUserMapping.class).eq("oidcClient", (Object)userRequest.getClientRegistration().getRegistrationId()).and().eq("oidcUsername", (Object)oidcUser.getSubject()).findOne();
        return oidcUserMapping != null ? Optional.of(oidcUserMapping.getUser()) : Optional.empty();
    }

    private User createUserMapping(OidcUser oidcUser, OidcUserRequest userRequest) {
        User user = (User)this.dataService.query("sys_sec_User", User.class).eq("Email", (Object)oidcUser.getEmail()).findOne();
        if (user == null) {
            user = this.createUser(oidcUser);
        }
        OidcClient oidcClient = this.getOidcClient(userRequest);
        OidcUserMapping oidcUserMapping = (OidcUserMapping)this.oidcUserMappingFactory.create();
        oidcUserMapping.setLabel(userRequest.getClientRegistration().getRegistrationId() + ":" + oidcUser.getSubject());
        oidcUserMapping.setOidcClient(oidcClient);
        oidcUserMapping.setOidcUsername(oidcUser.getSubject());
        oidcUserMapping.setUser(user);
        this.dataService.add("sys_sec_oidc_OidcUserMapping", (Entity)oidcUserMapping);
        return user;
    }

    private User createUser(OidcUser oidcUser) {
        User user = (User)this.userFactory.create();
        user.setUsername(oidcUser.getEmail());
        user.setPassword(UUID.randomUUID().toString());
        user.setEmail(oidcUser.getEmail());
        user.setActive(true);
        user.setFirstName(oidcUser.getGivenName());
        user.setLastName(oidcUser.getFamilyName());
        this.dataService.add("sys_sec_User", (Entity)user);
        return user;
    }

    private OidcClient getOidcClient(OidcUserRequest userRequest) {
        String registrationId = userRequest.getClientRegistration().getRegistrationId();
        OidcClient oidcClient = (OidcClient)this.dataService.findOneById("sys_sec_oidc_OidcClient", (Object)registrationId, OidcClient.class);
        if (oidcClient == null) {
            throw new UnknownEntityException("sys_sec_oidc_OidcClient", (Object)registrationId);
        }
        return oidcClient;
    }
}

