/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.account;

import java.time.Instant;
import java.util.Objects;
import org.molgenis.data.security.auth.PasswordResetToken;
import org.molgenis.util.exception.BadRequestException;

class ExpiredPasswordResetTokenException
extends BadRequestException {
    private static final String ERROR_CODE = "SEC02";
    private final String id;
    private final Instant expirationDate;

    ExpiredPasswordResetTokenException(PasswordResetToken passwordResetToken) {
        super(ERROR_CODE);
        Objects.requireNonNull(passwordResetToken);
        this.id = passwordResetToken.getId();
        this.expirationDate = passwordResetToken.getExpirationDate();
    }

    public String getMessage() {
        return "id:" + this.id + " expirationDate:" + this.expirationDate;
    }

    protected Object[] getLocalizedMessageArguments() {
        return new Object[0];
    }
}

