/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.acl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.Objects;
import org.molgenis.security.acl.MutableAclClassService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.acls.model.AclCache;
import org.springframework.transaction.annotation.Transactional;

public class MutableAclClassServiceImpl
implements MutableAclClassService {
    private static final String SQL_INSERT_INTO_ACL_CLASS = "insert into acl_class (class, class_id_type) values (?, ?)";
    private static final String SQL_DELETE_FROM_ACL_CLASS = "delete from acl_class where class=?";
    private static final String SQL_COUNT_ACL_CLASS = "select count(*) from acl_class WHERE class = ?";
    private static final String SQL_SELECT_ACL_CLASS = "select class from acl_class";
    private final JdbcTemplate jdbcTemplate;
    private final AclCache aclCache;
    private final Cache<String, Integer> aclClassCache;
    private static final Logger LOGGER = LoggerFactory.getLogger(MutableAclClassServiceImpl.class);

    public MutableAclClassServiceImpl(JdbcTemplate jdbcTemplate, AclCache aclCache) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
        this.aclCache = Objects.requireNonNull(aclCache);
        this.aclClassCache = Caffeine.newBuilder().maximumSize(1000L).build();
    }

    @Transactional
    public void createAclClass(String type, Class<?> idType) {
        LOGGER.debug("Create AclClass for type {}.", (Object)type);
        this.jdbcTemplate.update(SQL_INSERT_INTO_ACL_CLASS, new Object[]{type, idType.getCanonicalName()});
        this.aclClassCache.invalidate((Object)type);
    }

    @Transactional
    public void deleteAclClass(String type) {
        LOGGER.debug("Delete AclClass for type {}.", (Object)type);
        this.jdbcTemplate.update(SQL_DELETE_FROM_ACL_CLASS, new Object[]{type});
        this.aclClassCache.invalidate((Object)type);
        this.aclCache.clearCache();
    }

    public void clearCache() {
        LOGGER.debug("Invalidate cache.");
        this.aclClassCache.invalidateAll();
    }

    public boolean hasAclClass(String type) {
        boolean result = (Integer)this.aclClassCache.get((Object)type, t -> (Integer)this.jdbcTemplate.queryForObject(SQL_COUNT_ACL_CLASS, new Object[]{t}, Integer.class)) > 0;
        LOGGER.trace("hasAclClass({}): {}", (Object)type, (Object)result);
        return result;
    }

    public Collection<String> getAclClassTypes() {
        return this.jdbcTemplate.queryForList(SQL_SELECT_ACL_CLASS, String.class);
    }
}

