/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.login;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/login"})
public class MolgenisLoginController {
    public static final String PARAM_SESSION_EXPIRED = "expired";
    public static final String URI = "/login";
    public static final String ERROR_MESSAGE_ATTRIBUTE = "errorMessage";
    private static final String ERROR_MESSAGE_BAD_CREDENTIALS = "The username or password you entered is incorrect.";
    public static final String ERROR_MESSAGE_DISABLED = "Your account is not yet activated.";
    static final String ERROR_MESSAGE_SESSION_AUTHENTICATION = "Your login session has expired.";
    private static final String ERROR_MESSAGE_UNKNOWN = "Sign in failed.";
    static final String VIEW_LOGIN = "view-login";
    public static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    public static final String SPRING_SECURITY_SAVED_REQUEST = "SPRING_SECURITY_SAVED_REQUEST";
    public static final String JSESSIONID = "JSESSIONID";

    @GetMapping
    public String getLoginPage(HttpServletRequest httpServletRequest, Model model) {
        if (this.hasInvalidSessionId(httpServletRequest)) {
            return this.getLoginErrorPage(model);
        }
        return VIEW_LOGIN;
    }

    private boolean hasInvalidSessionId(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getSession(false) != null) {
            boolean hasSessionCookie;
            HttpSession session = httpServletRequest.getSession(false);
            SecurityContext context = (SecurityContext)session.getAttribute(SPRING_SECURITY_CONTEXT);
            boolean hasAuthentication = context != null && context.getAuthentication() != null;
            SavedRequest savedRequest = (SavedRequest)session.getAttribute(SPRING_SECURITY_SAVED_REQUEST);
            boolean bl = hasSessionCookie = savedRequest != null && this.hasSessionCookie(savedRequest);
            if (!hasAuthentication && hasSessionCookie) {
                return true;
            }
        }
        return false;
    }

    private boolean hasSessionCookie(SavedRequest savedRequest) {
        for (Cookie cookie : savedRequest.getCookies()) {
            if (!cookie.getName().equals(JSESSIONID)) continue;
            return true;
        }
        return false;
    }

    @GetMapping(params={"expired"})
    public String getLoginErrorPage(Model model) {
        model.addAttribute(ERROR_MESSAGE_ATTRIBUTE, (Object)ERROR_MESSAGE_SESSION_AUTHENTICATION);
        return VIEW_LOGIN;
    }

    @GetMapping(params={"error"})
    public String getLoginErrorPage(Model model, HttpServletRequest request) {
        Object attribute = request.getSession().getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        String errorMessage = attribute != null ? (attribute instanceof BadCredentialsException ? ERROR_MESSAGE_BAD_CREDENTIALS : (attribute instanceof SessionAuthenticationException ? ERROR_MESSAGE_SESSION_AUTHENTICATION : (!this.determineErrorMessagesFromInternalAuthenticationExceptions(attribute).isEmpty() ? this.determineErrorMessagesFromInternalAuthenticationExceptions(attribute) : ERROR_MESSAGE_UNKNOWN))) : ERROR_MESSAGE_UNKNOWN;
        model.addAttribute(ERROR_MESSAGE_ATTRIBUTE, (Object)errorMessage);
        return VIEW_LOGIN;
    }

    private String determineErrorMessagesFromInternalAuthenticationExceptions(Object attribute) {
        Throwable throwable;
        String errorMessage = "";
        if (attribute instanceof InternalAuthenticationServiceException && (throwable = ((InternalAuthenticationServiceException)attribute).getCause()).getCause() instanceof UsernameNotFoundException) {
            errorMessage = ERROR_MESSAGE_BAD_CREDENTIALS;
        }
        return errorMessage;
    }
}

