/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.oidc.model;

import java.util.Arrays;
import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.security.oidc.model.OidcPackage;
import org.springframework.stereotype.Component;

@Component
public class OidcClientMetadata
extends SystemEntityType {
    private static final String SIMPLE_NAME = "OidcClient";
    public static final String OIDC_CLIENT = "sys_sec_oidc_OidcClient";
    static final String REGISTRATION_ID = "registrationId";
    static final String CLIENT_ID = "clientId";
    static final String CLIENT_SECRET = "clientSecret";
    static final String CLIENT_NAME = "clientName";
    static final String CLIENT_AUTHENTICATION_METHOD = "clientAuthenticationMethod";
    static final String AUTHORIZATION_GRANT_TYPE = "authorizationGrantType";
    static final String SCOPES = "scopes";
    private static final String PROVIDER_DETAILS = "providerDetails";
    static final String AUTHORIZATION_URI = "authorizationUri";
    static final String TOKEN_URI = "tokenUri";
    static final String JWK_SET_URI = "jwkSetUri";
    static final String USER_INFO_URI = "userInfoUri";
    static final String USERNAME_ATTRIBUTE_NAME = "userNameAttributeName";
    private final OidcPackage oidcPackage;

    public OidcClientMetadata(OidcPackage oidcPackage) {
        super(SIMPLE_NAME, "sys_sec_oidc");
        this.oidcPackage = Objects.requireNonNull(oidcPackage);
    }

    public void init() {
        this.setPackage((Package)this.oidcPackage);
        this.setLabel("OIDC client");
        this.setDescription("OpenID Connect client registration");
        this.addAttribute(REGISTRATION_ID, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setLabel("Registration ID").setDescription("Registration identifier");
        this.addAttribute(CLIENT_ID, new EntityType.AttributeRole[0]).setLabel("Client ID").setDescription("Client identifier").setNillable(false).setUnique(true);
        this.addAttribute(CLIENT_SECRET, new EntityType.AttributeRole[0]).setLabel("Client secret").setNillable(false);
        this.addAttribute(CLIENT_NAME, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL, EntityType.AttributeRole.ROLE_LOOKUP}).setLabel("Client name").setDescription("Client name to be presented to the end user").setNillable(false).setUnique(true);
        this.addAttribute(CLIENT_AUTHENTICATION_METHOD, new EntityType.AttributeRole[0]).setLabel("Authentication").setDescription("Client authentication method").setNillable(false).setDefaultValue("basic");
        this.addAttribute(AUTHORIZATION_GRANT_TYPE, new EntityType.AttributeRole[0]).setLabel("Grant type").setDescription("Authorization grant type").setDataType(AttributeType.ENUM).setEnumOptions(Arrays.asList("authorization_code", "implicit", "refresh_token")).setNillable(false).setDefaultValue("authorization_code");
        this.addAttribute(SCOPES, new EntityType.AttributeRole[0]).setLabel("Scopes").setDescription("Comma-separated set of scopes").setNillable(false).setDefaultValue("openid,email,profile");
        Attribute providerDetailsAttribute = this.addAttribute(PROVIDER_DETAILS, new EntityType.AttributeRole[0]).setDataType(AttributeType.COMPOUND).setLabel("Provider details");
        this.addAttribute(AUTHORIZATION_URI, new EntityType.AttributeRole[0]).setParent(providerDetailsAttribute).setLabel("Authorization URI").setDataType(AttributeType.HYPERLINK).setNillable(false);
        this.addAttribute(TOKEN_URI, new EntityType.AttributeRole[0]).setParent(providerDetailsAttribute).setLabel("Token URI").setDataType(AttributeType.HYPERLINK).setNillable(false);
        this.addAttribute(JWK_SET_URI, new EntityType.AttributeRole[0]).setParent(providerDetailsAttribute).setLabel("JWKS URI").setDescription("JSON Web Key Set URI").setDataType(AttributeType.HYPERLINK).setNillable(false);
        this.addAttribute(USER_INFO_URI, new EntityType.AttributeRole[0]).setParent(providerDetailsAttribute).setLabel("User info URI").setDataType(AttributeType.HYPERLINK).setNillable(false);
        this.addAttribute(USERNAME_ATTRIBUTE_NAME, new EntityType.AttributeRole[0]).setParent(providerDetailsAttribute).setLabel("Username attribute").setDescription("Username attribute name").setNillable(false).setDefaultValue("sub");
    }
}

