/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.oidc.model;

import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.security.oidc.ResettableOAuth2AuthorizedClientService;
import org.molgenis.security.oidc.model.OidcClient;

class OidcClientRepositoryDecorator
extends AbstractRepositoryDecorator<OidcClient> {
    private final ResettableOAuth2AuthorizedClientService oAuth2AuthorizedClientService;

    OidcClientRepositoryDecorator(Repository<OidcClient> delegateRepository, ResettableOAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
        super(delegateRepository);
        this.oAuth2AuthorizedClientService = Objects.requireNonNull(oAuth2AuthorizedClientService);
    }

    public void update(OidcClient entity) {
        super.update((Entity)entity);
        this.oAuth2AuthorizedClientService.reset();
    }

    public void update(Stream<OidcClient> entities) {
        super.update(entities);
        this.oAuth2AuthorizedClientService.reset();
    }

    public void delete(OidcClient entity) {
        super.delete((Entity)entity);
        this.oAuth2AuthorizedClientService.reset();
    }

    public void deleteById(Object id) {
        super.deleteById(id);
        this.oAuth2AuthorizedClientService.reset();
    }

    public void deleteAll() {
        super.deleteAll();
        this.oAuth2AuthorizedClientService.reset();
    }

    public void delete(Stream<OidcClient> entities) {
        super.delete(entities);
        this.oAuth2AuthorizedClientService.reset();
    }

    public void deleteAll(Stream<Object> ids) {
        super.deleteAll(ids);
        this.oAuth2AuthorizedClientService.reset();
    }
}

