/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.oidc.model;

import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.auth.UserMetadata;
import org.molgenis.security.oidc.model.OidcClientMetadata;
import org.molgenis.security.oidc.model.OidcPackage;
import org.springframework.stereotype.Component;

@Component
public class OidcUserMappingMetadata
extends SystemEntityType {
    private static final String SIMPLE_NAME = "OidcUserMapping";
    public static final String OIDC_USER_MAPPING = "sys_sec_oidc_OidcUserMapping";
    public static final String ID = "id";
    public static final String LABEL = "label";
    public static final String OIDC_CLIENT = "oidcClient";
    public static final String OIDC_USERNAME = "oidcUsername";
    public static final String USER = "user";
    private final OidcPackage oidcPackage;
    private final OidcClientMetadata oidcClientMetadata;
    private final UserMetadata userMetadata;

    public OidcUserMappingMetadata(OidcPackage oidcPackage, OidcClientMetadata oidcClientMetadata, UserMetadata userMetadata) {
        super(SIMPLE_NAME, "sys_sec_oidc");
        this.oidcPackage = Objects.requireNonNull(oidcPackage);
        this.oidcClientMetadata = Objects.requireNonNull(oidcClientMetadata);
        this.userMetadata = Objects.requireNonNull(userMetadata);
    }

    public void init() {
        this.setPackage((Package)this.oidcPackage);
        this.setLabel("OIDC user mapping");
        this.setDescription("Mapping of OpenID Connect users to MOLGENIS users");
        this.addAttribute(ID, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setLabel("Identifier").setAuto(true).setVisible(false);
        this.addAttribute(LABEL, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL, EntityType.AttributeRole.ROLE_LOOKUP}).setLabel("Label").setNillable(false).setUnique(true);
        this.addAttribute(OIDC_CLIENT, new EntityType.AttributeRole[0]).setLabel("OIDC client").setDescription("OpenID Connect client").setDataType(AttributeType.XREF).setRefEntity((EntityType)this.oidcClientMetadata).setNillable(false);
        this.addAttribute(OIDC_USERNAME, new EntityType.AttributeRole[0]).setLabel("OIDC username").setDescription("OpenID Connect username").setNillable(false);
        this.addAttribute(USER, new EntityType.AttributeRole[0]).setLabel("User").setDescription("MOLGENIS user").setDataType(AttributeType.XREF).setRefEntity((EntityType)this.userMetadata).setNillable(false);
    }
}

