/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionRegistry;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.acls.domain.CumulativePermission;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class UserPermissionEvaluatorImpl
implements UserPermissionEvaluator {
    private final PermissionEvaluator permissionEvaluator;
    private final PermissionRegistry permissionRegistry;

    UserPermissionEvaluatorImpl(PermissionEvaluator permissionEvaluator, PermissionRegistry permissionRegistry) {
        this.permissionEvaluator = Objects.requireNonNull(permissionEvaluator);
        this.permissionRegistry = Objects.requireNonNull(permissionRegistry);
    }

    public boolean hasPermission(ObjectIdentity objectIdentity, Permission action) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return true;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && this.permissionEvaluator.hasPermission(authentication, objectIdentity.getIdentifier(), objectIdentity.getType(), (Object)this.getCumulativePermissionToCheck(action));
    }

    public boolean hasPermission(ObjectIdentity objectIdentity, List<Permission> permissions) {
        return permissions.stream().allMatch(permission -> this.hasPermission(objectIdentity, (Permission)permission));
    }

    public Set<Permission> getPermissions(ObjectIdentity objectIdentity, Permission[] permissions) {
        return Arrays.stream(permissions).filter(permission -> this.hasPermission(objectIdentity, (Permission)permission)).collect(Collectors.toSet());
    }

    private CumulativePermission getCumulativePermissionToCheck(Permission permission) {
        CumulativePermission result = new CumulativePermission();
        Set permissionSets = this.permissionRegistry.getPermissions(permission);
        permissionSets.forEach(arg_0 -> ((CumulativePermission)result).set(arg_0));
        return result;
    }
}

