/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.token;

import java.util.Objects;
import org.springframework.security.access.intercept.RunAsUserToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.stereotype.Component;

@Component
public class RunAsUserTokenFactory {
    private UserDetailsChecker userDetailsChecker;

    public RunAsUserTokenFactory(UserDetailsChecker userDetailsChecker) {
        this.userDetailsChecker = Objects.requireNonNull(userDetailsChecker);
    }

    public RunAsUserToken create(String key, UserDetails userDetails, Class<? extends Authentication> originalAuthentication) {
        this.userDetailsChecker.check(userDetails);
        return new RunAsUserToken(key, (Object)userDetails.getUsername(), (Object)userDetails.getPassword(), userDetails.getAuthorities(), originalAuthentication);
    }
}

