/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.token;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.security.token.RestAuthenticationToken;
import org.molgenis.security.token.TokenExtractor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class TokenAuthenticationFilter
extends GenericFilterBean {
    private final AuthenticationProvider authenticationProvider;

    public TokenAuthenticationFilter(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String token;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!httpRequest.getRequestURI().endsWith("login") && !httpRequest.getRequestURI().endsWith("logout") && StringUtils.isNotBlank((CharSequence)(token = TokenExtractor.getToken(httpRequest)))) {
            try {
                RestAuthenticationToken authToken = new RestAuthenticationToken(token);
                Authentication authentication = this.authenticationProvider.authenticate((Authentication)authToken);
                if (authentication.isAuthenticated()) {
                    SecurityContextHolder.getContext().setAuthentication(authentication);
                }
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
        }
        chain.doFilter(request, response);
    }
}

