/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.twofactor.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.user.UserService;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.security.twofactor.model.RecoveryCode;
import org.molgenis.security.twofactor.model.RecoveryCodeFactory;
import org.molgenis.security.twofactor.model.UserSecret;
import org.molgenis.security.twofactor.service.RecoveryService;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecoveryServiceImpl
implements RecoveryService {
    private static final int RECOVERY_CODE_COUNT = 10;
    private final DataService dataService;
    private final RecoveryCodeFactory recoveryCodeFactory;
    private final IdGenerator idGenerator;
    private final UserService userService;

    public RecoveryServiceImpl(DataService dataService, UserService userService, RecoveryCodeFactory recoveryCodeFactory, IdGenerator idGenerator) {
        this.dataService = Objects.requireNonNull(dataService);
        this.userService = Objects.requireNonNull(userService);
        this.recoveryCodeFactory = Objects.requireNonNull(recoveryCodeFactory);
        this.idGenerator = Objects.requireNonNull(idGenerator);
    }

    @Override
    @Transactional
    public Stream<RecoveryCode> generateRecoveryCodes() {
        String userId = this.getUser().getId();
        this.deleteOldRecoveryCodes(userId);
        List<RecoveryCode> newRecoveryCodes = this.generateRecoveryCodes(userId);
        RunAsSystemAspect.runAsSystem(() -> this.dataService.add("sys_sec_RecoveryCode", newRecoveryCodes.stream()));
        return newRecoveryCodes.stream();
    }

    @Override
    @Transactional
    public void useRecoveryCode(String recoveryCode) {
        String userId = this.getUser().getId();
        RecoveryCode existingCode = (RecoveryCode)((Object)RunAsSystemAspect.runAsSystem(() -> (RecoveryCode)this.dataService.query("sys_sec_RecoveryCode", RecoveryCode.class).eq("userId", (Object)userId).and().eq("code", (Object)recoveryCode).findOne()));
        if (existingCode == null) {
            throw new BadCredentialsException("Invalid recovery code or code already used");
        }
        RunAsSystemAspect.runAsSystem(() -> this.dataService.delete("sys_sec_RecoveryCode", (Entity)existingCode));
        UserSecret secret = (UserSecret)((Object)RunAsSystemAspect.runAsSystem(() -> (UserSecret)this.dataService.query("sys_sec_UserSecret", UserSecret.class).eq("userId", (Object)userId).findOne()));
        secret.setFailedLoginAttempts(0);
        RunAsSystemAspect.runAsSystem(() -> this.dataService.update("sys_sec_UserSecret", (Entity)secret));
    }

    @Override
    public Stream<RecoveryCode> getRecoveryCodes() {
        String userId = this.getUser().getId();
        return (Stream)RunAsSystemAspect.runAsSystem(() -> this.dataService.query("sys_sec_RecoveryCode", RecoveryCode.class).eq("userId", (Object)userId).findAll());
    }

    private void deleteOldRecoveryCodes(String userId) {
        RunAsSystemAspect.runAsSystem(() -> {
            Stream recoveryCodes = this.dataService.query("sys_sec_RecoveryCode", RecoveryCode.class).eq("userId", (Object)userId).findAll();
            this.dataService.delete("sys_sec_RecoveryCode", recoveryCodes);
        });
    }

    private List<RecoveryCode> generateRecoveryCodes(String userId) {
        ArrayList recoveryCodes = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            RecoveryCode recoveryCode = (RecoveryCode)this.recoveryCodeFactory.create();
            recoveryCode.setUserId(userId);
            recoveryCode.setCode(this.idGenerator.generateId(IdGenerator.Strategy.LONG_SECURE_RANDOM));
            recoveryCodes.add(recoveryCode);
        }
        return recoveryCodes;
    }

    private User getUser() {
        User user = this.userService.getUser(SecurityUtils.getCurrentUsername());
        if (user != null) {
            return user;
        }
        throw new UsernameNotFoundException("Can't find user: [" + SecurityUtils.getCurrentUsername() + "]");
    }
}

