/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.user;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.security.auth.Role;
import org.molgenis.data.security.auth.RoleMembership;
import org.molgenis.security.core.SidUtils;
import org.molgenis.security.core.runas.RunAsSystem;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserDetailsServiceImpl
implements UserDetailsService {
    private final DataService dataService;
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;

    public UserDetailsServiceImpl(DataService dataService, GrantedAuthoritiesMapper grantedAuthoritiesMapper) {
        this.dataService = Objects.requireNonNull(dataService);
        this.grantedAuthoritiesMapper = Objects.requireNonNull(grantedAuthoritiesMapper);
    }

    @RunAsSystem
    public UserDetails loadUserByUsername(String username) {
        org.molgenis.data.security.auth.User user = (org.molgenis.data.security.auth.User)this.dataService.query("sys_sec_User", org.molgenis.data.security.auth.User.class).eq("username", (Object)username).findOne();
        if (user == null) {
            throw new UsernameNotFoundException("unknown user '" + username + "'");
        }
        Collection<? extends GrantedAuthority> authorities = this.getAuthorities(user);
        return new User(user.getUsername(), user.getPassword(), user.isActive(), true, true, true, authorities);
    }

    @RunAsSystem
    public Collection<? extends GrantedAuthority> getAuthorities(org.molgenis.data.security.auth.User user) {
        LinkedHashSet<SimpleGrantedAuthority> authorities = new LinkedHashSet<SimpleGrantedAuthority>();
        if (user.isSuperuser()) {
            authorities.add(new SimpleGrantedAuthority("ROLE_SU"));
        }
        if (user.getUsername().equals("anonymous")) {
            authorities.add(new SimpleGrantedAuthority("ROLE_ANONYMOUS"));
        } else {
            authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        }
        this.dataService.query("sys_sec_RoleMembership", RoleMembership.class).eq("user", (Object)user).findAll().filter(RoleMembership::isCurrent).map(RoleMembership::getRole).map(Role::getName).map(SidUtils::createRoleAuthority).map(SimpleGrantedAuthority::new).forEach(authorities::add);
        return this.grantedAuthoritiesMapper.mapAuthorities(authorities);
    }
}

