/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import java.util.LinkedHashMap;
import javax.servlet.Filter;
import org.molgenis.data.DataService;
import org.molgenis.data.security.auth.TokenFactory;
import org.molgenis.data.security.auth.UserFactory;
import org.molgenis.data.security.user.UserService;
import org.molgenis.security.AjaxAwareLoginUrlAuthenticationEntryPoint;
import org.molgenis.security.MolgenisChangePasswordFilter;
import org.molgenis.security.TokenAwareSecurityContextRepository;
import org.molgenis.security.core.MolgenisPasswordEncoder;
import org.molgenis.security.core.token.TokenService;
import org.molgenis.security.exception.WebAppSecurityConfigException;
import org.molgenis.security.oidc.DataServiceClientRegistrationRepository;
import org.molgenis.security.oidc.MappedOidcUserService;
import org.molgenis.security.oidc.OidcUserMapper;
import org.molgenis.security.oidc.OidcUserMapperImpl;
import org.molgenis.security.oidc.ResettableOAuth2AuthorizedClientService;
import org.molgenis.security.oidc.model.OidcUserMappingFactory;
import org.molgenis.security.settings.AuthenticationSettings;
import org.molgenis.security.token.DataServiceTokenService;
import org.molgenis.security.token.TokenAuthenticationFilter;
import org.molgenis.security.token.TokenAuthenticationProvider;
import org.molgenis.security.token.TokenGenerator;
import org.molgenis.security.twofactor.auth.RecoveryAuthenticationProvider;
import org.molgenis.security.twofactor.auth.RecoveryAuthenticationProviderImpl;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationFilter;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationProvider;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationProviderImpl;
import org.molgenis.security.twofactor.service.OtpService;
import org.molgenis.security.twofactor.service.RecoveryService;
import org.molgenis.security.twofactor.service.TwoFactorAuthenticationService;
import org.molgenis.security.user.MolgenisUserDetailsChecker;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.security.user.UserDetailsServiceImpl;
import org.molgenis.web.i18n.HttpLocaleResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchyAuthoritiesMapper;
import org.springframework.security.access.intercept.RunAsImplAuthenticationProvider;
import org.springframework.security.access.vote.RoleHierarchyVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.authentication.switchuser.SwitchUserFilter;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.CacheControlHeadersWriter;
import org.springframework.security.web.header.writers.DelegatingRequestMatcherHeaderWriter;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.LocaleResolver;

@Import(value={DataServiceClientRegistrationRepository.class})
public abstract class MolgenisWebAppSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String ANONYMOUS_AUTHENTICATION_KEY = "anonymousAuthenticationKey";
    private static final String CONTINUE_WITH_UNSUPPORTED_BROWSER = "continueWithUnsupportedBrowser";
    @Autowired
    private DataService dataService;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthenticationSettings authenticationSettings;
    @Autowired
    private TokenFactory tokenFactory;
    @Autowired
    private UserFactory userFactory;
    @Autowired
    private OtpService otpService;
    @Autowired
    private TwoFactorAuthenticationService twoFactorAuthenticationService;
    @Autowired
    private RecoveryService recoveryService;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private ClientRegistrationRepository clientRegistrationRepository;
    @Autowired
    private OidcUserMappingFactory oidcUserMappingFactory;
    @Autowired
    private HttpLocaleResolver httpLocaleResolver;

    protected void configure(HttpSecurity http) throws Exception {
        NegatedRequestMatcher matcher = new NegatedRequestMatcher((RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/css/**"), new AntPathRequestMatcher("/js/**"), new AntPathRequestMatcher("/img/**"), new AntPathRequestMatcher("/fonts/**"), new AntPathRequestMatcher("/@molgenis-ui/**")}));
        DelegatingRequestMatcherHeaderWriter cacheControlHeaderWriter = new DelegatingRequestMatcherHeaderWriter((RequestMatcher)matcher, (HeaderWriter)new CacheControlHeadersWriter());
        http.securityContext().securityContextRepository(this.securityContextRepository());
        http.exceptionHandling().authenticationEntryPoint(this.delegatingEntryPoint());
        HttpSessionRequestCache requestCache = new HttpSessionRequestCache();
        requestCache.setRequestMatcher(this.createWebRequestMatcher());
        http.requestCache().requestCache((RequestCache)requestCache);
        ((HttpSecurity)http.cors().and()).headers().contentTypeOptions().and().xssProtection().and().httpStrictTransportSecurity().and().frameOptions().and().addHeaderWriter((HeaderWriter)cacheControlHeaderWriter);
        http.anonymous().key(ANONYMOUS_AUTHENTICATION_KEY).principal((Object)"anonymous").authorities(new String[]{"ROLE_ANONYMOUS"});
        http.authenticationProvider(this.tokenAuthenticationProvider());
        http.authenticationProvider(this.runAsAuthenticationProvider());
        http.addFilterBefore(this.tokenAuthenticationFilter(), AnonymousAuthenticationFilter.class);
        http.addFilterAfter(this.changePasswordFilter(), SwitchUserFilter.class);
        http.addFilterAfter((Filter)this.twoFactorAuthenticationFilter(), MolgenisChangePasswordFilter.class);
        http.authenticationProvider((AuthenticationProvider)this.twoFactorAuthenticationProvider());
        http.authenticationProvider((AuthenticationProvider)this.recoveryAuthenticationProvider());
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = http.authorizeRequests();
        this.configureUrlAuthorization(expressionInterceptUrlRegistry);
        ((HttpSecurity)((HttpSecurity)((OAuth2LoginConfigurer)((HttpSecurity)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(new String[]{"/login"})).permitAll().antMatchers(new String[]{"/2fa/**"})).permitAll().antMatchers(new String[]{"/beacon/**"})).permitAll().antMatchers(new String[]{"/logo/**"})).permitAll().antMatchers(new String[]{"/molgenis.py"})).permitAll().antMatchers(new String[]{"/molgenis.R"})).permitAll().antMatchers(new String[]{"/account/password/change"})).permitAll().antMatchers(new String[]{"/account/**"})).permitAll().antMatchers(new String[]{"/swagger/**"})).permitAll().antMatchers(new String[]{"/css/**"})).permitAll().antMatchers(new String[]{"/img/**"})).permitAll().antMatchers(new String[]{"/js/**"})).permitAll().antMatchers(new String[]{"/fonts/**"})).permitAll().antMatchers(new String[]{"/@molgenis-ui/**"})).permitAll().antMatchers(new String[]{"/html/**"})).permitAll().antMatchers(new String[]{"/plugin/void/**"})).permitAll().antMatchers(new String[]{"/app-ui-context/**"})).permitAll().antMatchers(new String[]{"/api/**"})).permitAll().antMatchers(new String[]{"/webjars/**"})).permitAll().antMatchers(new String[]{"/search"})).permitAll().antMatchers(new String[]{"/dataindexerstatus"})).authenticated().antMatchers(new String[]{"/permission/**/read/**"})).permitAll().antMatchers(new String[]{"/permission/**/write/**"})).permitAll().antMatchers(new String[]{"/scripts/**/run"})).authenticated().antMatchers(new String[]{"/scripts/**/start"})).authenticated().antMatchers(new String[]{"/scripts/**/submit"})).authenticated().antMatchers(new String[]{"/files/**"})).permitAll().antMatchers(new String[]{"/apps/**"})).permitAll().anyRequest()).denyAll().and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint()).and()).formLogin().loginPage("/login").failureUrl("/login?error")).and()).oauth2Login().clientRegistrationRepository(this.clientRegistrationRepository).authorizedClientService((OAuth2AuthorizedClientService)this.authorizedClientService()).loginPage("/login").failureUrl("/login")).userInfoEndpoint().oidcUserService((OAuth2UserService)this.oidcUserService()).and().and()).logout().deleteCookies(new String[]{"JSESSIONID"}).addLogoutHandler((req, res, auth) -> {
            if (req.getSession(false) != null && req.getSession().getAttribute(CONTINUE_WITH_UNSUPPORTED_BROWSER) != null) {
                req.setAttribute(CONTINUE_WITH_UNSUPPORTED_BROWSER, (Object)true);
            }
        }).logoutSuccessHandler((req, res, auth) -> {
            StringBuilder logoutSuccessUrl = new StringBuilder("/");
            if (req.getAttribute(CONTINUE_WITH_UNSUPPORTED_BROWSER) != null) {
                logoutSuccessUrl.append("?continueWithUnsupportedBrowser=true");
            }
            SimpleUrlLogoutSuccessHandler logoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
            logoutSuccessHandler.setDefaultTargetUrl(logoutSuccessUrl.toString());
            logoutSuccessHandler.onLogoutSuccess(req, res, auth);
        }).and()).csrf().disable();
    }

    @Bean
    public AuthenticationEntryPoint delegatingEntryPoint() {
        LoginUrlAuthenticationEntryPoint pluginEntryPoint = new LoginUrlAuthenticationEntryPoint("/login");
        LinkedHashMap<RequestMatcher, LoginUrlAuthenticationEntryPoint> entryPoints = new LinkedHashMap<RequestMatcher, LoginUrlAuthenticationEntryPoint>();
        entryPoints.put(this.createWebRequestMatcher(), pluginEntryPoint);
        DelegatingAuthenticationEntryPoint delegatingEntryPoint = new DelegatingAuthenticationEntryPoint(entryPoints);
        delegatingEntryPoint.setDefaultEntryPoint((AuthenticationEntryPoint)new Http403ForbiddenEntryPoint());
        return delegatingEntryPoint;
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/css/**"})).antMatchers(new String[]{"/img/**"})).antMatchers(new String[]{"/js/**"})).antMatchers(new String[]{"/@molgenis-ui/**"})).antMatchers(new String[]{"/fonts/**"});
    }

    @Bean
    public AuthenticationProvider runAsAuthenticationProvider() {
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        provider.setKey("Job Execution");
        return provider;
    }

    protected abstract void configureUrlAuthorization(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry var1);

    protected abstract RoleHierarchy roleHierarchy();

    @Bean
    public TokenService tokenService() {
        return new DataServiceTokenService(new TokenGenerator(), this.dataService, this.userDetailsService(), this.tokenFactory);
    }

    @Bean
    public AuthenticationProvider tokenAuthenticationProvider() {
        return new TokenAuthenticationProvider(this.tokenService(), this.userDetailsChecker());
    }

    @Bean
    public SecurityContextRepository securityContextRepository() {
        return new TokenAwareSecurityContextRepository((SecurityContextRepository)new NullSecurityContextRepository(), (SecurityContextRepository)new HttpSessionSecurityContextRepository());
    }

    @Bean
    public Filter tokenAuthenticationFilter() {
        return new TokenAuthenticationFilter(this.tokenAuthenticationProvider());
    }

    @Bean
    public Filter changePasswordFilter() {
        return new MolgenisChangePasswordFilter(this.userService, this.redirectStrategy());
    }

    @Bean
    public TwoFactorAuthenticationFilter twoFactorAuthenticationFilter() {
        return new TwoFactorAuthenticationFilter(this.authenticationSettings, this.twoFactorAuthenticationService, this.redirectStrategy(), this.userAccountService);
    }

    @Bean
    public TwoFactorAuthenticationProvider twoFactorAuthenticationProvider() {
        return new TwoFactorAuthenticationProviderImpl(this.twoFactorAuthenticationService, this.otpService, this.recoveryService);
    }

    @Bean
    public RecoveryAuthenticationProvider recoveryAuthenticationProvider() {
        return new RecoveryAuthenticationProviderImpl(this.recoveryService);
    }

    @Bean
    public RedirectStrategy redirectStrategy() {
        return new DefaultRedirectStrategy();
    }

    @Bean
    public RoleHierarchy roleHierarchyBean() {
        return this.roleHierarchy();
    }

    @Bean
    public RoleVoter roleVoter() {
        return new RoleHierarchyVoter(this.roleHierarchyBean());
    }

    @Bean
    public GrantedAuthoritiesMapper roleHierarchyAuthoritiesMapper() {
        return new RoleHierarchyAuthoritiesMapper(this.roleHierarchyBean());
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new MolgenisPasswordEncoder(new BCryptPasswordEncoder());
    }

    @Bean
    protected UserDetailsServiceImpl userDetailsService() {
        return new UserDetailsServiceImpl(this.dataService, this.roleHierarchyAuthoritiesMapper());
    }

    @Bean
    public UserDetailsService userDetailsServiceBean() {
        return this.userDetailsService();
    }

    @Bean
    public UserDetailsChecker userDetailsChecker() {
        return new MolgenisUserDetailsChecker();
    }

    protected void configure(AuthenticationManagerBuilder auth) {
        try {
            DaoAuthenticationProvider authenticationProvider = new DaoAuthenticationProvider();
            authenticationProvider.setPasswordEncoder(this.passwordEncoder());
            authenticationProvider.setUserDetailsService(this.userDetailsServiceBean());
            authenticationProvider.setPreAuthenticationChecks(this.userDetailsChecker());
            auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
        }
        catch (Exception e) {
            throw new WebAppSecurityConfigException(e);
        }
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint authenticationEntryPoint() {
        return new AjaxAwareLoginUrlAuthenticationEntryPoint("/login");
    }

    @Bean
    public HttpSessionEventPublisher httpSessionEventPublisher() {
        return new HttpSessionEventPublisher();
    }

    @Bean
    public ResettableOAuth2AuthorizedClientService authorizedClientService() {
        return new ResettableOAuth2AuthorizedClientService(this.clientRegistrationRepository);
    }

    @Bean
    public OidcUserService oidcUserService() {
        return new MappedOidcUserService(this.oidcUserMapper(), this.userDetailsService());
    }

    @Bean
    public OidcUserMapper oidcUserMapper() {
        return new OidcUserMapperImpl(this.dataService, this.oidcUserMappingFactory, this.userFactory);
    }

    @Bean
    public LocaleResolver localeResolver() {
        return this.httpLocaleResolver;
    }

    private RequestMatcher createWebRequestMatcher() {
        return new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/"), new AntPathRequestMatcher("/plugin/**"), new AntPathRequestMatcher("/menu/**")});
    }
}

