/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.captcha;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.molgenis.security.captcha.ReCaptchaHttpPostFactory;
import org.molgenis.security.captcha.ReCaptchaValidationResponse;
import org.molgenis.settings.AppSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReCaptchaService {
    private static final Logger LOG = LoggerFactory.getLogger(ReCaptchaService.class);
    private static final String LOG_MESSAGE = "Failed reCaptcha validation";
    private final AppSettings appSettings;
    private final CloseableHttpClient httpClient;
    private final ReCaptchaHttpPostFactory reCaptchaHttpPostFactory;

    public ReCaptchaService(CloseableHttpClient httpClient, AppSettings appSettings, ReCaptchaHttpPostFactory reCaptchaHttpPostFactory) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.appSettings = Objects.requireNonNull(appSettings);
        this.reCaptchaHttpPostFactory = Objects.requireNonNull(reCaptchaHttpPostFactory);
    }

    @Timed(value="recaptcha.validate", description="Timing information for the reCaptcha validation service.", histogram=true)
    public boolean validate(String token) {
        HttpPost httpPost = null;
        boolean isValid = false;
        try {
            httpPost = this.reCaptchaHttpPostFactory.create(this.appSettings.getRecaptchaVerifyURI());
            BasicNameValuePair secret = new BasicNameValuePair("secret", this.appSettings.getRecaptchaPrivateKey());
            BasicNameValuePair responseToken = new BasicNameValuePair("response", token);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(secret, responseToken)));
        }
        catch (UnsupportedEncodingException err) {
            LOG.error(LOG_MESSAGE, (Throwable)err);
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 300) {
                Gson gson = new Gson();
                JsonParser parser = new JsonParser();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                JsonObject object = (JsonObject)parser.parse(result);
                ReCaptchaValidationResponse validationResult = (ReCaptchaValidationResponse)gson.fromJson((JsonElement)object, ReCaptchaValidationResponse.class);
                isValid = validationResult.isSuccess() && validationResult.getScore() > this.appSettings.getRecaptchaBotThreshold();
            }
        }
        catch (IOException | NumberFormatException err) {
            LOG.error(LOG_MESSAGE, (Throwable)err);
        }
        return isValid;
    }
}

