/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.molgenis.security.permission.SecurityContextRegistryImpl;
import org.springframework.stereotype.Component;

@Component
public class SessionMetrics {
    private final SecurityContextRegistryImpl sessions;
    private MeterRegistry meterRegistry;

    SessionMetrics(SecurityContextRegistryImpl sessions, MeterRegistry meterRegistry) {
        this.sessions = Objects.requireNonNull(sessions);
        this.meterRegistry = Objects.requireNonNull(meterRegistry);
    }

    @PostConstruct
    public void bindToRegistry() {
        Gauge.builder((String)"spring.sessions", (Object)this.sessions, SessionMetrics::getSessions).description("The number of sessions, including expired sessions").register(this.meterRegistry);
    }

    private static long getSessions(SecurityContextRegistryImpl sessions) {
        return sessions.getSecurityContexts().count();
    }
}

