/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.oidc;

import com.google.common.collect.Streams;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.oidc.model.OidcClient;
import org.molgenis.security.settings.AuthenticationSettings;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.stereotype.Component;

@Component
public class DataServiceClientRegistrationRepository
implements ClientRegistrationRepository {
    private static final String DEFAULT_REDIRECT_URI_TEMPLATE = "{baseUrl}/login/oauth2/code/{registrationId}";
    private final AuthenticationSettings authenticationSettings;

    public DataServiceClientRegistrationRepository(AuthenticationSettings authenticationSettings) {
        this.authenticationSettings = Objects.requireNonNull(authenticationSettings);
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        return (ClientRegistration)RunAsSystemAspect.runAsSystem(() -> {
            OidcClient oidcClient = this.findOidcClient(registrationId);
            return oidcClient != null ? this.toClientRegistration(oidcClient) : null;
        });
    }

    @Nullable
    @CheckForNull
    private OidcClient findOidcClient(String registrationId) {
        return Streams.stream(this.authenticationSettings.getOidcClients()).filter(oidcClient -> oidcClient.getRegistrationId().equals(registrationId)).findFirst().orElse(null);
    }

    private ClientRegistration toClientRegistration(OidcClient oidcClient) {
        return ClientRegistration.withRegistrationId((String)oidcClient.getRegistrationId()).authorizationGrantType(this.toAuthorizationGrantType(oidcClient)).authorizationUri(oidcClient.getAuthorizationUri()).clientAuthenticationMethod(this.toClientAuthenticationMethod(oidcClient)).clientId(oidcClient.getClientId()).clientName(oidcClient.getClientName()).clientSecret(oidcClient.getClientSecret()).jwkSetUri(oidcClient.getJwkSetUri()).redirectUriTemplate(DEFAULT_REDIRECT_URI_TEMPLATE).scope(oidcClient.getScopes()).tokenUri(oidcClient.getTokenUri()).userInfoUri(oidcClient.getUserInfoUri()).userNameAttributeName(oidcClient.getUsernameAttributeName()).build();
    }

    private ClientAuthenticationMethod toClientAuthenticationMethod(OidcClient oidcClient) {
        ClientAuthenticationMethod clientAuthenticationMethod;
        String oidcClientClientAuthenticationMethod;
        switch (oidcClientClientAuthenticationMethod = oidcClient.getClientAuthenticationMethod()) {
            case "basic": {
                clientAuthenticationMethod = ClientAuthenticationMethod.BASIC;
                break;
            }
            case "post": {
                clientAuthenticationMethod = ClientAuthenticationMethod.POST;
                break;
            }
            default: {
                clientAuthenticationMethod = new ClientAuthenticationMethod(oidcClientClientAuthenticationMethod);
            }
        }
        return clientAuthenticationMethod;
    }

    private AuthorizationGrantType toAuthorizationGrantType(OidcClient oidcClient) {
        AuthorizationGrantType authorizationGrantType;
        String oidcClientAuthorizationGrantType;
        switch (oidcClientAuthorizationGrantType = oidcClient.getAuthorizationGrantType()) {
            case "authorization_code": {
                authorizationGrantType = AuthorizationGrantType.AUTHORIZATION_CODE;
                break;
            }
            case "implicit": {
                authorizationGrantType = AuthorizationGrantType.IMPLICIT;
                break;
            }
            default: {
                authorizationGrantType = new AuthorizationGrantType(oidcClientAuthorizationGrantType);
            }
        }
        return authorizationGrantType;
    }
}

