/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.account;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.naming.NoPermissionException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.molgenis.core.util.CountryCodes;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.auth.UserFactory;
import org.molgenis.security.account.AccountService;
import org.molgenis.security.account.ChangePasswordForm;
import org.molgenis.security.account.EmailAlreadyExistsException;
import org.molgenis.security.account.PasswordResetRequest;
import org.molgenis.security.account.PasswordResetter;
import org.molgenis.security.account.RegisterRequest;
import org.molgenis.security.account.UsernameAlreadyExistsException;
import org.molgenis.security.captcha.CaptchaException;
import org.molgenis.security.captcha.ReCaptchaService;
import org.molgenis.security.settings.AuthenticationSettings;
import org.molgenis.security.user.MolgenisUserException;
import org.molgenis.settings.AppSettings;
import org.molgenis.web.ErrorMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Controller
@RequestMapping(value={"/account"})
public class AccountController {
    private static final Logger LOG = LoggerFactory.getLogger(AccountController.class);
    public static final String URI = "/account";
    private static final String CHANGE_PASSWORD_RELATIVE_URI = "/password/change";
    public static final String CHANGE_PASSWORD_URI = "/account/password/change";
    static final String REGISTRATION_SUCCESS_MESSAGE_USER = "You have successfully registered, an activation e-mail has been sent to your email.";
    static final String REGISTRATION_SUCCESS_MESSAGE_ADMIN = "You have successfully registered, your request has been forwarded to the administrator.";
    private final AccountService accountService;
    private final ReCaptchaService reCaptchaService;
    private final AuthenticationSettings authenticationSettings;
    private final UserFactory userFactory;
    private final AppSettings appSettings;
    private final PasswordResetter passwordResetter;

    public AccountController(AccountService accountService, ReCaptchaService reCaptchaV3Service, AuthenticationSettings authenticationSettings, UserFactory userFactory, AppSettings appSettings, PasswordResetter passwordResetter) {
        this.accountService = Objects.requireNonNull(accountService);
        this.reCaptchaService = Objects.requireNonNull(reCaptchaV3Service);
        this.authenticationSettings = Objects.requireNonNull(authenticationSettings);
        this.userFactory = Objects.requireNonNull(userFactory);
        this.appSettings = Objects.requireNonNull(appSettings);
        this.passwordResetter = Objects.requireNonNull(passwordResetter);
    }

    @GetMapping(value={"/login"})
    public String getLoginForm() {
        return "login-modal";
    }

    @GetMapping(value={"/register"})
    public ModelAndView getRegisterForm() {
        ModelAndView model = new ModelAndView("register-modal");
        model.addObject("countries", (Object)CountryCodes.get());
        model.addObject("min_password_length", (Object)6);
        model.addObject("isRecaptchaEnabled", (Object)this.appSettings.getRecaptchaIsEnabled());
        model.addObject("recaptchaPublicKey", (Object)this.appSettings.getRecaptchaPublicKey());
        return model;
    }

    @GetMapping(value={"/activate"})
    public String getActivateView() {
        return "view-activate";
    }

    @GetMapping(value={"/activate-success"})
    public String getActivateSuccessView() {
        return "view-activate-success";
    }

    @GetMapping(value={"/password/reset"})
    public String getPasswordResetForm() {
        return "resetpassword-modal";
    }

    @GetMapping(value={"/password/change"})
    public String getPasswordResetChangeForm(Model model) {
        model.addAttribute("min_password_length", (Object)6);
        model.addAttribute("changePasswordEndpoint", (Object)CHANGE_PASSWORD_URI);
        return "view-change-password";
    }

    @GetMapping(value={"/password/change"}, params={"token"})
    public String getPasswordResetChangeFormToken(@RequestParam(value="username") String username, @RequestParam(value="token") String token, Model model) {
        this.passwordResetter.validatePasswordResetToken(username, token);
        model.addAttribute("min_password_length", (Object)6);
        model.addAttribute("changePasswordEndpoint", (Object)("/account/password/change?username=" + username + "&token=" + token));
        return "view-change-password";
    }

    @PostMapping(value={"/password/change"})
    public String changePassword(@Valid ChangePasswordForm form) {
        this.passwordResetter.changePasswordAuthenticatedUser(form.getPassword1());
        return "redirect:/";
    }

    @PostMapping(value={"/password/change"}, params={"token"})
    public String changePasswordToken(@RequestParam(value="username") String username, @RequestParam(value="token") String token, @Valid ChangePasswordForm changePasswordForm) {
        this.passwordResetter.changePassword(username, token, changePasswordForm.getPassword1());
        return "redirect:/login";
    }

    @PostMapping(value={"/register"}, headers={"Content-Type=application/x-www-form-urlencoded"})
    @ResponseBody
    public Map<String, String> registerUser(@Valid @ModelAttribute RegisterRequest registerRequest, HttpServletRequest request) throws Exception {
        if (this.authenticationSettings.getSignUp()) {
            if (!registerRequest.getPassword().equals(registerRequest.getConfirmPassword())) {
                throw new BindException(RegisterRequest.class, "password does not match confirm password");
            }
            if (this.appSettings.getRecaptchaIsEnabled() && !this.reCaptchaService.validate(registerRequest.getRecaptcha())) {
                throw new CaptchaException("invalid captcha answer");
            }
            User user = this.toUser(registerRequest);
            String activationUri = ServletUriComponentsBuilder.fromCurrentRequest().replacePath("/account/activate").toUriString();
            this.accountService.createUser(user, activationUri);
            String successMessage = this.authenticationSettings.getSignUpModeration() ? REGISTRATION_SUCCESS_MESSAGE_ADMIN : REGISTRATION_SUCCESS_MESSAGE_USER;
            return Collections.singletonMap("message", successMessage);
        }
        throw new NoPermissionException("Self registration is disabled");
    }

    @PostMapping(value={"/activate"})
    public final String activateUser(@RequestParam(value="activationCode") String activationCode, Model model) {
        try {
            this.accountService.activateUser(activationCode);
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)e.getMessage());
            return "view-activate";
        }
        return "view-activate-success";
    }

    @PostMapping(value={"/password/reset"}, headers={"Content-Type=application/x-www-form-urlencoded"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetPassword(@Valid @ModelAttribute PasswordResetRequest passwordResetRequest) {
        this.passwordResetter.resetPassword(passwordResetRequest.getEmail());
    }

    @ExceptionHandler(value={MolgenisDataAccessException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    private void handleMolgenisDataAccessException(MolgenisDataAccessException e) {
    }

    @ExceptionHandler(value={CaptchaException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    private void handleCaptchaException(CaptchaException e) {
    }

    @ExceptionHandler(value={MolgenisUserException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessageResponse handleMolgenisUserException(MolgenisUserException e) {
        LOG.debug("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ExceptionHandler(value={UsernameAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessageResponse handleUsernameAlreadyExistsException(UsernameAlreadyExistsException e) {
        LOG.debug("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ExceptionHandler(value={EmailAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessageResponse handleEmailAlreadyExistsException(EmailAlreadyExistsException e) {
        LOG.debug("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ExceptionHandler(value={MolgenisDataException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessageResponse handleMolgenisDataException(MolgenisDataException e) {
        LOG.error("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    private User toUser(RegisterRequest request) {
        User user = (User)this.userFactory.create();
        user.setUsername(request.getUsername());
        user.setPassword(request.getPassword());
        user.setEmail(request.getEmail());
        user.setPhone(request.getPhone());
        user.setFax(request.getFax());
        user.setTollFreePhone(request.getTollFreePhone());
        user.setAddress(request.getAddress());
        user.setTitle(request.getTitle());
        user.setLastName(request.getLastname());
        user.setFirstName(request.getFirstname());
        user.setDepartment(request.getDepartment());
        user.setCity(request.getCity());
        user.setCountry(CountryCodes.get((String)request.getCountry()));
        user.setChangePassword(Boolean.valueOf(false));
        user.setSuperuser(false);
        return user;
    }
}

