/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.account;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.user.UserService;
import org.molgenis.security.account.AccountService;
import org.molgenis.security.account.EmailAlreadyExistsException;
import org.molgenis.security.account.UsernameAlreadyExistsException;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.settings.AuthenticationSettings;
import org.molgenis.security.user.MolgenisUserException;
import org.molgenis.settings.AppSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountServiceImpl
implements AccountService {
    private static final Logger LOG = LoggerFactory.getLogger(AccountServiceImpl.class);
    private final DataService dataService;
    private final MailSender mailSender;
    private final UserService userService;
    private final AppSettings appSettings;
    private final AuthenticationSettings authenticationSettings;
    private final IdGenerator idGenerator;

    AccountServiceImpl(DataService dataService, MailSender mailSender, UserService userService, AppSettings appSettings, AuthenticationSettings authenticationSettings, IdGenerator idGenerator) {
        this.dataService = Objects.requireNonNull(dataService);
        this.mailSender = Objects.requireNonNull(mailSender);
        this.userService = Objects.requireNonNull(userService);
        this.appSettings = Objects.requireNonNull(appSettings);
        this.authenticationSettings = Objects.requireNonNull(authenticationSettings);
        this.idGenerator = Objects.requireNonNull(idGenerator);
    }

    @Override
    @RunAsSystem
    @Transactional
    public void createUser(User user, String baseActivationUri) throws UsernameAlreadyExistsException, EmailAlreadyExistsException {
        List<String> activationEmailAddresses;
        if (this.userService.getUser(user.getUsername()) != null) {
            throw new UsernameAlreadyExistsException("Username '" + user.getUsername() + "' already exists.");
        }
        if (this.userService.getUserByEmail(user.getEmail()) != null) {
            throw new EmailAlreadyExistsException("Email '" + user.getEmail() + "' is already registered.");
        }
        String activationCode = this.idGenerator.generateId(IdGenerator.Strategy.SECURE_RANDOM);
        if (this.authenticationSettings.getSignUpModeration()) {
            activationEmailAddresses = this.userService.getSuEmailAddresses();
            if (activationEmailAddresses == null || activationEmailAddresses.isEmpty()) {
                throw new MolgenisDataException("Administrator account is missing required email address");
            }
        } else {
            String activationEmailAddress = user.getEmail();
            if (activationEmailAddress == null || activationEmailAddress.isEmpty()) {
                throw new MolgenisDataException("User '" + user.getUsername() + "' is missing required email address");
            }
            activationEmailAddresses = Collections.singletonList(activationEmailAddress);
        }
        user.setActivationCode(activationCode);
        user.setActive(false);
        this.dataService.add("sys_sec_User", (Entity)user);
        LOG.debug("created user {}", (Object)user.getUsername());
        try {
            SimpleMailMessage mailMessage = new SimpleMailMessage();
            mailMessage.setTo(activationEmailAddresses.toArray(new String[0]));
            mailMessage.setSubject("User registration for " + this.appSettings.getTitle());
            mailMessage.setText(this.createActivationEmailTestWithCode(user, URI.create(baseActivationUri), activationCode));
            this.mailSender.send(mailMessage);
        }
        catch (MailException mce) {
            LOG.error("Could not send signup mail", (Throwable)mce);
            throw new MolgenisUserException("An error occurred. Please contact the administrator. You are not signed up!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("send activation email for user {} to {}", (Object)user.getUsername(), (Object)StringUtils.join(activationEmailAddresses, (char)','));
        }
    }

    @Override
    @RunAsSystem
    public void activateUser(String activationCode) {
        User user = (User)this.dataService.query("sys_sec_User", User.class).eq("active", (Object)false).and().eq("activationCode", (Object)activationCode).findOne();
        if (user == null) {
            throw new MolgenisUserException("Invalid activation code or account already activated.");
        }
        user.setActive(true);
        this.dataService.update("sys_sec_User", (Entity)user);
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(user.getEmail());
        mailMessage.setSubject("Your registration request for " + this.appSettings.getTitle());
        mailMessage.setText(this.createActivatedEmailText(user, this.appSettings.getTitle()));
        this.mailSender.send(mailMessage);
    }

    private String createActivationEmailTestWithCode(User user, URI activationUri, String activationCode) {
        return "User registration for " + this.appSettings.getTitle() + "\nUser name: " + user.getUsername() + " Full name: " + user.getFirstName() + " " + user.getLastName() + "\n\nIn order to activate your account go to: " + activationUri + "\n\nand activate your account using the following code: " + activationCode + "\n\n";
    }

    private String createActivatedEmailText(User user, String appName) {
        String firstName = user.getFirstName();
        String lastName = user.getLastName();
        if (firstName == null || firstName.isEmpty()) {
            firstName = user.getUsername();
        }
        if (lastName == null || lastName.isEmpty()) {
            lastName = null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Dear ");
        builder.append(firstName);
        if (lastName != null) {
            builder.append(" ");
            builder.append(lastName);
        }
        builder.append(",\n\n");
        builder.append("Your registration request for ");
        builder.append(appName);
        builder.append(" was approved.\n");
        builder.append("Your account is now active.\n\n");
        builder.append("Kind regards,\n\n");
        builder.append("Server administrator");
        return builder.toString();
    }
}

