/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.account;

import java.net.URI;
import java.util.Objects;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.user.InvalidEmailAddressException;
import org.molgenis.data.security.user.UnknownUserException;
import org.molgenis.data.security.user.UserService;
import org.molgenis.security.account.PasswordResetTokenRepository;
import org.molgenis.security.account.PasswordResetter;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.settings.AppSettings;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Component
class PasswordResetterImpl
implements PasswordResetter {
    private final PasswordResetTokenRepository passwordResetTokenService;
    private final UserService userService;
    private final MailSender mailSender;
    private final AppSettings appSettings;

    PasswordResetterImpl(PasswordResetTokenRepository passwordResetTokenRepository, UserService userService, MailSender mailSender, AppSettings appSettings) {
        this.passwordResetTokenService = Objects.requireNonNull(passwordResetTokenRepository);
        this.userService = Objects.requireNonNull(userService);
        this.mailSender = Objects.requireNonNull(mailSender);
        this.appSettings = Objects.requireNonNull(appSettings);
    }

    @Override
    @Transactional
    @RunAsSystem
    public void resetPassword(String emailAddress) {
        User user = this.getUserByEmail(emailAddress);
        String token = this.passwordResetTokenService.createToken(user);
        this.sendPasswordResetMail(user, token);
    }

    @Override
    @Transactional(readOnly=true)
    @RunAsSystem
    public void validatePasswordResetToken(String username, String token) {
        User user = this.getUser(username);
        this.passwordResetTokenService.validateToken(user, token);
    }

    @Override
    @Transactional
    @RunAsSystem
    public void changePassword(String username, String token, String password) {
        User user = this.getUser(username);
        this.passwordResetTokenService.validateToken(user, token);
        user.setPassword(password);
        this.userService.update(user);
        this.passwordResetTokenService.deleteToken(user, token);
    }

    @Override
    @Transactional
    public void changePasswordAuthenticatedUser(String password) {
        String username = SecurityUtils.getCurrentUsername();
        if (username == null) {
            throw new AuthenticationCredentialsNotFoundException("not authenticated");
        }
        User user = this.getUser(username);
        user.setPassword(password);
        user.setChangePassword(Boolean.valueOf(false));
        RunAsSystemAspect.runAsSystem(() -> this.userService.update(user));
    }

    private User getUser(String username) {
        User user = this.userService.getUser(username);
        if (user == null) {
            throw new UnknownUserException(username);
        }
        return user;
    }

    private User getUserByEmail(String emailAddress) {
        User user = this.userService.getUserByEmail(emailAddress);
        if (user == null) {
            throw new InvalidEmailAddressException();
        }
        return user;
    }

    private URI createPasswordResetUri(String username, String token) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentServletMapping();
        builder.encode();
        builder.path("/account/password/change");
        builder.queryParam("username", new Object[]{username});
        builder.queryParam("token", new Object[]{token});
        return builder.build().toUri();
    }

    private void sendPasswordResetMail(User user, String token) {
        URI passwordResetUri = this.createPasswordResetUri(user.getUsername(), token);
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(user.getEmail());
        mailMessage.setSubject(String.format("Password reset on %s", this.appSettings.getTitle()));
        mailMessage.setText("Hello,\n\nYou are receiving this email because we received a password reset request for your account.\n\n" + passwordResetUri.toString() + "\n\nIf you did not request a password reset, you can safely ignore this email.");
        this.mailSender.send(mailMessage);
    }
}

