/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.acl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Objects;
import javax.sql.DataSource;
import org.molgenis.util.ResourceUtils;
import org.molgenis.util.UncheckedSqlException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component
public class DataSourceAclTablesPopulator {
    private final DataSource dataSource;

    public DataSourceAclTablesPopulator(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    public void populate() {
        ArrayList<String> resourceNames = new ArrayList<String>(4);
        resourceNames.add("/sql/create_table_acl_sid.sql");
        resourceNames.add("/sql/create_table_acl_class.sql");
        resourceNames.add("/sql/create_table_acl_object_identity.sql");
        resourceNames.add("/sql/create_table_acl_entry.sql");
        Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try {
            resourceNames.forEach(resourceName -> this.createTable(connection, (String)resourceName));
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }

    private void createTable(Connection connection, String resourceName) {
        try (Statement statement = connection.createStatement();){
            String sql = ResourceUtils.getString(this.getClass(), (String)resourceName, (Charset)StandardCharsets.UTF_8);
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new UncheckedSqlException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

