/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.security.core.PrincipalSecurityContextRegistry;
import org.molgenis.security.core.SecurityContextRegistry;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;

@Component
public class PrincipalSecurityContextRegistryImpl
implements PrincipalSecurityContextRegistry {
    private final SecurityContextRegistry securityContextRegistry;

    PrincipalSecurityContextRegistryImpl(SecurityContextRegistry securityContextRegistry) {
        this.securityContextRegistry = Objects.requireNonNull(securityContextRegistry);
    }

    public Stream<SecurityContext> getSecurityContexts(Object principal) {
        HashSet<SecurityContext> securityContexts = new HashSet<SecurityContext>();
        SecurityContext currentExecutionThreadSecurityContext = this.getSecurityContextCurrentExecutionThread(principal);
        if (currentExecutionThreadSecurityContext != null) {
            securityContexts.add(currentExecutionThreadSecurityContext);
        }
        this.getSecurityContextsFromRegistry(principal).forEach(securityContexts::add);
        return securityContexts.stream();
    }

    private SecurityContext getSecurityContextCurrentExecutionThread(Object principal) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null && authentication.getPrincipal().equals(principal)) {
            return securityContext;
        }
        return null;
    }

    private Stream<SecurityContext> getSecurityContextsFromRegistry(Object principal) {
        String username = this.getUsername(principal);
        return this.securityContextRegistry.getSecurityContexts().filter(securityContext -> {
            Object securityContextPrincipal;
            Authentication authentication = securityContext.getAuthentication();
            return authentication != null && username.equals(this.getUsername(securityContextPrincipal = authentication.getPrincipal()));
        });
    }

    private String getUsername(Object principal) {
        String username = principal instanceof User ? ((User)principal).getUsername() : principal.toString();
        return username;
    }
}

