/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.swagger.controller;

import java.io.IOException;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.security.core.token.TokenService;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.web.PluginController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;

@Controller
@RequestMapping(value={"/plugin/swagger"})
public class SwaggerController
extends PluginController {
    private static final String ID = "swagger";
    public static final String URI = "/plugin/swagger";
    private final MetaDataService metaDataService;
    private final TokenService tokenService;

    @Autowired
    public SwaggerController(MetaDataService metaDataService, TokenService tokenService) throws IOException {
        super(URI);
        this.metaDataService = Objects.requireNonNull(metaDataService);
        this.tokenService = Objects.requireNonNull(tokenService);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) {
        model.addAttribute("url", (Object)ServletUriComponentsBuilder.fromCurrentContextPath().path("/plugin/swagger/swagger.yml").toUriString());
        String currentUsername = SecurityUtils.getCurrentUsername();
        if (currentUsername != null) {
            model.addAttribute("token", (Object)this.tokenService.generateAndStoreToken(currentUsername, "For Swagger UI"));
        }
        return "view-swagger-ui";
    }

    @RequestMapping(path={"/swagger.yml"}, produces={"text/yaml"}, method={RequestMethod.GET})
    public String swagger(Model model, HttpServletResponse response) {
        response.setContentType("text/yaml");
        response.setCharacterEncoding("UTF-8");
        UriComponents uriComponents = ServletUriComponentsBuilder.fromCurrentContextPath().build();
        model.addAttribute("scheme", (Object)uriComponents.getScheme());
        String host = uriComponents.getHost();
        if (uriComponents.getPort() >= 0) {
            host = host + ":" + uriComponents.getPort();
        }
        model.addAttribute("host", (Object)host);
        model.addAttribute("entityTypes", this.metaDataService.getEntityTypes().filter(e -> !e.isAbstract()).map(EntityType::getId).sorted().collect(Collectors.toList()));
        model.addAttribute("attributeTypes", (Object)AttributeType.getOptionsLowercase());
        return "view-swagger";
    }
}

