/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.swagger.controller;

import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.security.core.token.TokenService;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.util.i18n.LanguageService;
import org.molgenis.web.PluginController;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;

@Controller
@RequestMapping(value={"/plugin/swagger"})
public class SwaggerController
extends PluginController {
    private static final String ID = "swagger";
    public static final String URI = "/plugin/swagger";
    private final MetaDataService metaDataService;
    private final TokenService tokenService;

    public SwaggerController(MetaDataService metaDataService, TokenService tokenService) {
        super(URI);
        this.metaDataService = Objects.requireNonNull(metaDataService);
        this.tokenService = Objects.requireNonNull(tokenService);
    }

    @GetMapping
    public String init(Model model) {
        UriComponents uriComponents = ServletUriComponentsBuilder.fromCurrentContextPath().build();
        model.addAttribute("molgenisUrl", (Object)(uriComponents.toUriString() + "/plugin/swagger/swagger.yml"));
        model.addAttribute("baseUrl", (Object)uriComponents.toUriString());
        String currentUsername = SecurityUtils.getCurrentUsername();
        if (currentUsername != null) {
            model.addAttribute("token", (Object)this.tokenService.generateAndStoreToken(currentUsername, "For Swagger UI"));
        }
        return "view-swagger-ui";
    }

    @GetMapping(value={"/swagger.yml"}, produces={"text/yaml"})
    public String swagger(Model model, HttpServletResponse response) {
        response.setContentType("text/yaml");
        response.setCharacterEncoding("UTF-8");
        UriComponents uriComponents = ServletUriComponentsBuilder.fromCurrentContextPath().build();
        model.addAttribute("scheme", (Object)uriComponents.getScheme());
        Object host = uriComponents.getHost();
        if (uriComponents.getPort() >= 0) {
            host = (String)host + ":" + uriComponents.getPort();
        }
        model.addAttribute("host", host);
        model.addAttribute("entityTypes", this.metaDataService.getEntityTypes().filter(e -> !e.isAbstract()).map(EntityType::getId).sorted().collect(Collectors.toList()));
        model.addAttribute("attributeTypes", (Object)AttributeType.getOptionsLowercase());
        model.addAttribute("languageCodes", LanguageService.getLanguageCodes().collect(Collectors.toList()));
        return "view-swagger";
    }
}

